/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310ArraySerializerBase;
import java.io.IOException;
import java.time.LocalTime;
import java.time.temporal.ChronoField;

public class LocalTimeSerializer
extends JSR310ArraySerializerBase<LocalTime> {
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    private LocalTimeSerializer() {
        super(LocalTime.class);
    }

    public void serialize(LocalTime localTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(localTime.getHour());
            jsonGenerator.writeNumber(localTime.getMinute());
            if (localTime.getSecond() > 0 || localTime.getNano() > 0) {
                jsonGenerator.writeNumber(localTime.getSecond());
                if (localTime.getNano() > 0) {
                    if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        jsonGenerator.writeNumber(localTime.getNano());
                    } else {
                        jsonGenerator.writeNumber(localTime.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(localTime.toString());
        }
    }
}

