/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310ArraySerializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.temporal.ChronoField;

public class OffsetTimeSerializer
extends JSR310ArraySerializerBase<OffsetTime> {
    public static final OffsetTimeSerializer INSTANCE = new OffsetTimeSerializer();

    protected OffsetTimeSerializer() {
        super(OffsetTime.class);
    }

    public void serialize(OffsetTime offsetTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(offsetTime.getHour());
            jsonGenerator.writeNumber(offsetTime.getMinute());
            if (offsetTime.getSecond() > 0 || offsetTime.getNano() > 0) {
                jsonGenerator.writeNumber(offsetTime.getSecond());
                if (offsetTime.getNano() > 0) {
                    if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        jsonGenerator.writeNumber(offsetTime.getNano());
                    } else {
                        jsonGenerator.writeNumber(offsetTime.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            jsonGenerator.writeString(offsetTime.getOffset().toString());
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(offsetTime.toString());
        }
    }
}

