/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.pcollections.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import org.pcollections.PCollection;

public abstract class PCollectionsCollectionDeserializer<T extends PCollection<Object>>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final CollectionType _containerType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _typeDeserializerForValue;

    protected PCollectionsCollectionDeserializer(CollectionType type, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super((JavaType)type);
        this._containerType = type;
        this._typeDeserializerForValue = typeDeser;
        this._valueDeserializer = deser;
    }

    protected abstract T createEmptyCollection();

    public abstract PCollectionsCollectionDeserializer<T> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._containerType.getContentType(), property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._typeDeserializerForValue) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.isExpectedStartArrayToken()) {
            return this._deserializeContents(jp, ctxt);
        }
        if (ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return this._deserializeFromSingleValue(jp, ctxt);
        }
        throw ctxt.mappingException(this._containerType.getRawClass());
    }

    protected T _deserializeContents(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t;
        JsonDeserializer<?> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        Object collection = this.createEmptyCollection();
        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            Object value = t == JsonToken.VALUE_NULL ? null : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
            PCollection newCollection = collection.plus(value);
            collection = newCollection;
        }
        return collection;
    }

    protected T _deserializeFromSingleValue(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonDeserializer<?> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        JsonToken t = jp.getCurrentToken();
        Object value = t == JsonToken.VALUE_NULL ? null : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
        PCollection result = this.createEmptyCollection().plus(value);
        return (T)result;
    }
}

