/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.pcollections.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import org.pcollections.PMap;

public abstract class PCollectionsMapDeserializer<T extends PMap<Object, Object>>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    protected final MapType _mapType;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _typeDeserializerForValue;

    protected PCollectionsMapDeserializer(MapType type, KeyDeserializer keyDeser, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        this._mapType = type;
        this._keyDeserializer = keyDeser;
        this._typeDeserializerForValue = typeDeser;
        this._valueDeserializer = deser;
    }

    public abstract PCollectionsMapDeserializer<T> withResolved(KeyDeserializer var1, TypeDeserializer var2, JsonDeserializer<?> var3);

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer keyDeser = this._keyDeserializer;
        JsonDeserializer deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        if (keyDeser != null && deser != null && typeDeser == null) {
            return this;
        }
        if (keyDeser == null) {
            keyDeser = ctxt.findKeyDeserializer(this._mapType.getKeyType(), property);
        }
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._mapType.getContentType(), property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(keyDeser, typeDeser, deser);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        if (t != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT) {
            throw ctxt.mappingException(this._mapType.getRawClass());
        }
        return this._deserializeEntries(jp, ctxt);
    }

    protected abstract T createEmptyMap();

    protected T _deserializeEntries(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer<?> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._typeDeserializerForValue;
        Object map = this.createEmptyMap();
        while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = p.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t = p.nextToken();
            if (t == JsonToken.VALUE_NULL) {
                map = this._handleNull(ctxt, key, this._valueDeserializer, map);
            } else {
                Object value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
                PMap newMap = map.plus((Object)key, value);
                map = newMap;
            }
            p.nextToken();
        }
        return map;
    }

    protected T _handleNull(DeserializationContext ctxt, Object key, JsonDeserializer<?> valueDeser, T map) throws IOException {
        Object nvl = valueDeser.getNullValue(ctxt);
        if (nvl != null) {
            PMap newMap = map.plus(key, nvl);
            return (T)newMap;
        }
        return map;
    }
}

