/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import java.io.IOException;
import java.lang.annotation.Annotation;

abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _originalSettable;
    protected final BeanPropertyMutator _propertyMutator;
    protected final int _optimizedIndex;

    public OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._originalSettable = src;
        this._propertyMutator = mutator;
        this._optimizedIndex = index;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, JsonDeserializer<?> deser) {
        super(src, deser);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._optimizedIndex = src._optimizedIndex;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, PropertyName name) {
        super(src, name);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._optimizedIndex = src._optimizedIndex;
    }

    public abstract T withMutator(BeanPropertyMutator var1);

    public abstract T withValueDeserializer(JsonDeserializer<?> var1);

    public <A extends Annotation> A getAnnotation(Class<A> ann) {
        return (A)this._originalSettable.getAnnotation(ann);
    }

    public AnnotatedMember getMember() {
        return this._originalSettable.getMember();
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public abstract void set(Object var1, Object var2) throws IOException;

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._originalSettable.setAndReturn(instance, value);
    }

    protected final int _deserializeInt(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasTokenId(7)) {
            return p.getIntValue();
        }
        return p.getValueAsInt();
    }

    protected final long _deserializeLong(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasTokenId(7)) {
            return p.getLongValue();
        }
        return p.getValueAsLong();
    }

    protected final boolean _deserializeBoolean(JsonParser p, DeserializationContext ctxt) throws IOException {
        int id = p.getCurrentTokenId();
        if (id == 9) {
            return true;
        }
        if (id == 10) {
            return false;
        }
        return p.getValueAsBoolean();
    }

    protected final String _deserializeString(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasTokenId(11)) {
            if (this._nullProvider == null) {
                return null;
            }
            return (String)this._nullProvider.nullValue(ctxt);
        }
        String text = p.getValueAsString();
        if (text != null) {
            return text;
        }
        return this._convertToString(p, ctxt);
    }

    protected final String _convertToString(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasTokenId(12)) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        JsonToken curr = p.getCurrentToken();
        if (curr.isScalarValue()) {
            return p.getText();
        }
        if (curr == JsonToken.VALUE_NULL) {
            return null;
        }
        throw ctxt.mappingException(String.class);
    }
}

