/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import java.io.IOException;

public class AdditionalPropertiesDeserializer
extends JsonDeserializer<ObjectSchema.AdditionalProperties> {
    public ObjectSchema.AdditionalProperties deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        TreeNode node = mapper.readTree(jp);
        String nodeStr = mapper.writeValueAsString((Object)node);
        if (node instanceof ObjectNode) {
            JsonSchema innerSchema = (JsonSchema)mapper.readValue(nodeStr, JsonSchema.class);
            return new ObjectSchema.SchemaAdditionalProperties(innerSchema);
        }
        if (node instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)node;
            if (booleanNode.booleanValue()) {
                return null;
            }
            return ObjectSchema.NoAdditionalProperties.instance;
        }
        throw new JsonMappingException("additionalProperties nodes can only be of type boolean or object: " + nodeStr);
    }
}

