/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.io.Stax2FileResult;
import org.codehaus.stax2.ri.Stax2WriterAdapter;
import org.codehaus.staxmate.out.SMOutputContext;
import org.codehaus.staxmate.out.SMOutputDocument;
import org.codehaus.staxmate.out.SMRootFragment;

public final class SMOutputFactory {
    final XMLOutputFactory _staxFactory;
    final XMLOutputFactory2 _stax2Factory;

    public SMOutputFactory(XMLOutputFactory staxF) {
        this._staxFactory = staxF;
        this._stax2Factory = staxF instanceof XMLOutputFactory2 ? (XMLOutputFactory2)staxF : null;
    }

    public XMLOutputFactory getStaxFactory() {
        return this._staxFactory;
    }

    public static SMOutputDocument createOutputDocument(XMLStreamWriter sw) throws XMLStreamException {
        return SMOutputContext.createInstance(Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)sw)).createDocument();
    }

    public SMOutputDocument createOutputDocument(File f) throws XMLStreamException {
        return SMOutputContext.createInstance(this.createStax2Writer(f)).createDocument();
    }

    public SMOutputDocument createOutputDocument(OutputStream out) throws XMLStreamException {
        return SMOutputContext.createInstance(this.createStax2Writer(out)).createDocument();
    }

    public SMOutputDocument createOutputDocument(Writer w) throws XMLStreamException {
        return SMOutputContext.createInstance(this.createStax2Writer(w)).createDocument();
    }

    public static SMOutputDocument createOutputDocument(XMLStreamWriter sw, String version, String encoding, boolean standAlone) throws XMLStreamException {
        return SMOutputContext.createInstance(Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)sw)).createDocument(version, encoding, standAlone);
    }

    public static SMRootFragment createOutputFragment(XMLStreamWriter sw) throws XMLStreamException {
        return SMOutputContext.createInstance(Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)sw)).createRootFragment();
    }

    public SMRootFragment createOutputFragment(File resultFile) throws XMLStreamException {
        return SMOutputContext.createInstance(this.createStax2Writer(resultFile)).createRootFragment();
    }

    public SMRootFragment createOutputFragment(OutputStream out) throws XMLStreamException {
        return SMOutputContext.createInstance(this.createStax2Writer(out)).createRootFragment();
    }

    public SMRootFragment createOutputFragment(Writer w) throws XMLStreamException {
        return SMOutputContext.createInstance(this.createStax2Writer(w)).createRootFragment();
    }

    public XMLStreamWriter2 createStax2Writer(File f) throws XMLStreamException {
        if (this._stax2Factory != null) {
            Stax2FileResult res = new Stax2FileResult(f);
            return (XMLStreamWriter2)this._stax2Factory.createXMLStreamWriter((Result)res);
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            return Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)this._staxFactory.createXMLStreamWriter(out));
        }
        catch (FileNotFoundException fex) {
            throw new XMLStreamException(fex);
        }
    }

    public XMLStreamWriter2 createStax2Writer(OutputStream out) throws XMLStreamException {
        return Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)this._staxFactory.createXMLStreamWriter(out));
    }

    public XMLStreamWriter2 createStax2Writer(Writer w) throws XMLStreamException {
        return Stax2WriterAdapter.wrapIfNecessary((XMLStreamWriter)this._staxFactory.createXMLStreamWriter(w));
    }

    public static SMOutputFactory getGlobalSMOutputFactory() throws FactoryConfigurationError {
        return SMFactoryAccessor.getFactory();
    }

    public static XMLOutputFactory getGlobalXMLOutputFactory() throws XMLStreamException {
        try {
            return XmlFactoryAccessor.getFactory();
        }
        catch (FactoryConfigurationError err) {
            throw new XMLStreamException(err);
        }
    }

    private static final class SMFactoryAccessor {
        static final SMFactoryAccessor sInstance = new SMFactoryAccessor();
        SMOutputFactory mFactory = null;

        private SMFactoryAccessor() {
        }

        public static SMOutputFactory getFactory() throws FactoryConfigurationError {
            return sInstance.get();
        }

        private synchronized SMOutputFactory get() throws FactoryConfigurationError {
            if (this.mFactory == null) {
                this.mFactory = new SMOutputFactory(XmlFactoryAccessor.getFactory());
            }
            return this.mFactory;
        }
    }

    private static final class XmlFactoryAccessor {
        static final XmlFactoryAccessor sInstance = new XmlFactoryAccessor();
        XMLOutputFactory mFactory = null;

        private XmlFactoryAccessor() {
        }

        public static XMLOutputFactory getFactory() throws FactoryConfigurationError {
            return sInstance.get();
        }

        public synchronized XMLOutputFactory get() throws FactoryConfigurationError {
            if (this.mFactory == null) {
                this.mFactory = XMLOutputFactory.newInstance();
            }
            return this.mFactory;
        }
    }
}

