/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.javaluator.examples;

import com.fathzer.soft.javaluator.AbstractEvaluator;
import com.fathzer.soft.javaluator.BracketPair;
import com.fathzer.soft.javaluator.Constant;
import com.fathzer.soft.javaluator.Operator;
import com.fathzer.soft.javaluator.Parameters;
import java.util.BitSet;
import java.util.Iterator;

public class BooleanSetEvaluator
extends AbstractEvaluator<BitSet> {
    public static final Operator NEGATE = new Operator("-", 1, Operator.Associativity.RIGHT, 3);
    private static final Operator AND = new Operator("*", 2, Operator.Associativity.LEFT, 2);
    public static final Operator OR = new Operator("+", 2, Operator.Associativity.LEFT, 1);
    public static final Constant TRUE = new Constant("true");
    public static final Constant FALSE = new Constant("false");
    private static final Parameters PARAMETERS = new Parameters();

    public BooleanSetEvaluator() {
        super(PARAMETERS);
    }

    protected BitSet toValue(String literal, Object evaluationContext) {
        int length = ((BitSetEvaluationContext)evaluationContext).getBitSetLength();
        if (literal.length() != length) {
            throw new IllegalArgumentException(literal + " must have a length of " + length);
        }
        BitSet result = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            if (literal.charAt(i) == '1') {
                result.set(i);
                continue;
            }
            if (literal.charAt(i) == '0') continue;
            throw new IllegalArgumentException(literal + " contains the wrong character " + literal.charAt(i));
        }
        return result;
    }

    protected BitSet evaluate(Operator operator, Iterator<BitSet> operands, Object evaluationContext) {
        BitSet o1 = operands.next();
        if (operator == NEGATE) {
            int length = ((BitSetEvaluationContext)evaluationContext).getBitSetLength();
            o1.flip(0, length);
        } else {
            BitSet o2 = operands.next();
            if (operator == OR) {
                o1.or(o2);
            } else if (operator == AND) {
                o1.and(o2);
            } else {
                o1 = (BitSet)super.evaluate(operator, operands, evaluationContext);
            }
        }
        return o1;
    }

    protected BitSet evaluate(Constant constant, Object evaluationContext) {
        BitSet result;
        int length = ((BitSetEvaluationContext)evaluationContext).getBitSetLength();
        if (constant == FALSE) {
            result = new BitSet(length);
        } else if (constant == TRUE) {
            result = new BitSet(length);
            result.flip(0, length);
        } else {
            result = (BitSet)super.evaluate(constant, evaluationContext);
        }
        return result;
    }

    public static void main(String[] args) {
        BooleanSetEvaluator evaluator = new BooleanSetEvaluator();
        BitSetEvaluationContext context = new BitSetEvaluationContext(4);
        BooleanSetEvaluator.doIt(evaluator, "0011 * 1010", context);
        BooleanSetEvaluator.doIt(evaluator, "true * 1100", context);
        BooleanSetEvaluator.doIt(evaluator, "-false", context);
    }

    private static void doIt(BooleanSetEvaluator evaluator, String expression, BitSetEvaluationContext context) {
        BitSet result = (BitSet)evaluator.evaluate(expression, context);
        System.out.println(expression + " = " + BooleanSetEvaluator.toBinaryString(result));
    }

    public static String toBinaryString(BitSet bitSet) {
        StringBuilder builder = new StringBuilder(bitSet.length());
        for (int i = 0; i < bitSet.length(); ++i) {
            builder.append(bitSet.get(i) ? (char)'1' : '0');
        }
        String res = builder.toString();
        return res;
    }

    static {
        PARAMETERS.add(AND);
        PARAMETERS.add(OR);
        PARAMETERS.add(NEGATE);
        PARAMETERS.add(TRUE);
        PARAMETERS.add(FALSE);
        PARAMETERS.addExpressionBracket(BracketPair.PARENTHESES);
    }

    public static class BitSetEvaluationContext {
        private int bitSetLength;

        public BitSetEvaluationContext(int bitSetLength) {
            this.bitSetLength = bitSetLength;
        }

        public int getBitSetLength() {
            return this.bitSetLength;
        }
    }
}

