/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.javaluator.examples;

import com.fathzer.soft.javaluator.AbstractEvaluator;
import com.fathzer.soft.javaluator.Operator;
import com.fathzer.soft.javaluator.Parameters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TextualOperatorsEvaluator
extends AbstractEvaluator<Boolean> {
    public static final Operator NEGATE = new Operator("NOT", 1, Operator.Associativity.RIGHT, 3);
    private static final Operator AND = new Operator("AND", 2, Operator.Associativity.LEFT, 2);
    public static final Operator OR = new Operator("OR", 2, Operator.Associativity.LEFT, 1);
    private static final Parameters PARAMETERS = new Parameters();

    public TextualOperatorsEvaluator() {
        super(PARAMETERS);
    }

    protected Boolean toValue(String literal, Object evaluationContext) {
        int index = literal.indexOf(61);
        if (index >= 0) {
            String variable = literal.substring(0, index);
            String value = literal.substring(index + 1);
            return value.equals(((Map)evaluationContext).get(variable));
        }
        return Boolean.valueOf(literal);
    }

    protected Boolean evaluate(Operator operator, Iterator<Boolean> operands, Object evaluationContext) {
        if (operator == NEGATE) {
            return operands.next() == false;
        }
        if (operator == OR) {
            Boolean o1 = operands.next();
            Boolean o2 = operands.next();
            return o1 != false || o2 != false;
        }
        if (operator == AND) {
            Boolean o1 = operands.next();
            Boolean o2 = operands.next();
            return o1 != false && o2 != false;
        }
        return (Boolean)super.evaluate(operator, operands, evaluationContext);
    }

    protected Iterator<String> tokenize(String expression) {
        return Arrays.asList(expression.split("\\s")).iterator();
    }

    public static void main(String[] args) {
        HashMap<String, String> variableToValue = new HashMap<String, String>();
        variableToValue.put("type", "PORT");
        TextualOperatorsEvaluator evaluator = new TextualOperatorsEvaluator();
        System.out.println("type=PORT -> " + evaluator.evaluate("type=PORT", variableToValue));
        System.out.println("type=NORTH -> " + evaluator.evaluate("type=NORTH", variableToValue));
        System.out.println("type=PORT AND true -> " + evaluator.evaluate("type=PORT AND true", variableToValue));
    }

    static {
        PARAMETERS.add(AND);
        PARAMETERS.add(OR);
        PARAMETERS.add(NEGATE);
    }
}

