/* The following code was generated by JFlex 1.4.1 on 3/28/20 4:50 PM */

/*
 * 12/06/2005
 *
 * PythonTokenMaker.java - Token maker for the Python programming language.
 *
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.AbstractJFlexTokenMaker;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;


/**
 * Scanner for the Python programming language.
 *
 * @author Robert Futrell
 * @version 0.3
 */

public class PythonTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int LONG_STRING_2 = 2;
  public static final int LONG_STRING_1 = 1;

  /**
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED =
    "\11\0\1\35\1\12\1\0\1\35\1\33\22\0\1\35\1\70\1\11"+
    "\1\34\1\0\1\67\1\73\1\10\1\63\1\63\1\66\1\65\1\70"+
    "\1\27\1\24\1\67\1\16\7\21\2\3\1\70\1\75\1\71\1\64"+
    "\1\72\1\70\1\32\4\23\1\26\1\61\3\2\1\31\1\2\1\15"+
    "\1\2\1\62\3\2\1\6\1\2\1\60\1\7\2\2\1\20\2\2"+
    "\1\63\1\13\1\63\1\70\1\1\1\0\1\36\1\43\1\45\1\40"+
    "\1\25\1\22\1\53\1\55\1\47\1\30\1\44\1\14\1\52\1\37"+
    "\1\46\1\50\1\2\1\4\1\41\1\42\1\5\1\56\1\54\1\17"+
    "\1\51\1\57\1\63\1\74\1\63\1\70\uff81\0";

  /**
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\2\1\3\4\2\2\4\1\5\1\2"+
    "\1\3\2\2\1\6\1\2\1\6\1\1\1\7\1\10"+
    "\24\2\1\11\10\6\1\2\2\12\2\4\1\13\1\3"+
    "\1\14\1\13\1\14\4\2\2\4\1\0\2\4\1\0"+
    "\4\2\1\13\1\3\1\13\11\2\1\15\1\2\1\16"+
    "\27\2\1\16\3\2\2\16\1\17\1\16\20\2\3\0"+
    "\2\14\1\0\12\2\1\4\1\20\1\21\3\2\1\3"+
    "\15\2\1\16\22\2\1\22\16\2\1\23\1\24\1\14"+
    "\6\2\1\22\3\2\1\16\24\2\1\25\12\2\1\16"+
    "\17\2\1\16\6\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[276];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\76\0\174\0\272\0\370\0\u0136\0\u0174\0\u01b2"+
    "\0\u01f0\0\u022e\0\u026c\0\u02aa\0\272\0\u02e8\0\u0326\0\u0364"+
    "\0\u03a2\0\u03e0\0\u041e\0\u045c\0\u049a\0\u04d8\0\u0516\0\u0554"+
    "\0\u0592\0\u05d0\0\u060e\0\u064c\0\u068a\0\u06c8\0\u0706\0\u0744"+
    "\0\u0782\0\u07c0\0\u07fe\0\u083c\0\u087a\0\u08b8\0\u08f6\0\u0934"+
    "\0\u0972\0\u09b0\0\u09ee\0\272\0\u0a2c\0\u0a6a\0\u0aa8\0\272"+
    "\0\u0ae6\0\u0b24\0\u0b62\0\u0ba0\0\272\0\u0bde\0\u0c1c\0\u0c5a"+
    "\0\u0c98\0\u0cd6\0\u0cd6\0\u0d14\0\u0d52\0\u0cd6\0\u0d90\0\u0dce"+
    "\0\u0e0c\0\u0e4a\0\u0e88\0\u0ec6\0\u0f04\0\u0f42\0\u0f80\0\u0fbe"+
    "\0\u0ffc\0\u103a\0\u1078\0\u10b6\0\u10f4\0\u1132\0\u1170\0\u11ae"+
    "\0\u11ec\0\u122a\0\u1268\0\u12a6\0\u12e4\0\u1322\0\u1360\0\u139e"+
    "\0\u13dc\0\u141a\0\u1458\0\u1496\0\u14d4\0\u1512\0\u1550\0\u158e"+
    "\0\u15cc\0\u160a\0\u1648\0\u1686\0\u16c4\0\u1702\0\u1740\0\u177e"+
    "\0\u17bc\0\u17fa\0\u1838\0\u1876\0\u18b4\0\u18f2\0\u1930\0\u196e"+
    "\0\u19ac\0\u19ea\0\u1a28\0\u1a66\0\u1aa4\0\u1ae2\0\370\0\u1b20"+
    "\0\370\0\u1b5e\0\u1b9c\0\u1bda\0\u1c18\0\u1c56\0\u1c94\0\u1cd2"+
    "\0\u1d10\0\u1d4e\0\u1d8c\0\u1dca\0\u1e08\0\u1e46\0\u1e84\0\u1ec2"+
    "\0\u1f00\0\u1f3e\0\u1f7c\0\u1fba\0\u1ff8\0\272\0\u2036\0\u2074"+
    "\0\u20b2\0\u20f0\0\u212e\0\u216c\0\u21aa\0\u21e8\0\u2226\0\u2264"+
    "\0\u22a2\0\u22e0\0\272\0\272\0\272\0\u231e\0\u235c\0\u239a"+
    "\0\u23d8\0\u2416\0\u2454\0\u2492\0\u24d0\0\u250e\0\u254c\0\u258a"+
    "\0\u25c8\0\u2606\0\u2644\0\u2682\0\u26c0\0\u26fe\0\u273c\0\u277a"+
    "\0\u27b8\0\u27f6\0\u273c\0\u2834\0\u2872\0\u28b0\0\u28ee\0\u292c"+
    "\0\u296a\0\u29a8\0\u29e6\0\u2a24\0\u2a62\0\u2aa0\0\u2ade\0\u2b1c"+
    "\0\u2b5a\0\u2b98\0\u2bd6\0\u2c14\0\u2c52\0\u2c90\0\u2cce\0\u2d0c"+
    "\0\u2d4a\0\u2d88\0\u2dc6\0\u2e04\0\u2e42\0\u2e80\0\u2ebe\0\u2efc"+
    "\0\272\0\272\0\u2f3a\0\u2f78\0\u2fb6\0\u2ff4\0\u1a28\0\u3032"+
    "\0\u3070\0\370\0\u30ae\0\u30ec\0\u312a\0\u3168\0\u31a6\0\u31e4"+
    "\0\u3222\0\u3260\0\u329e\0\u32dc\0\u331a\0\u3358\0\u3396\0\u33d4"+
    "\0\u3412\0\u3450\0\u348e\0\u34cc\0\u350a\0\u3548\0\u3586\0\u35c4"+
    "\0\u3602\0\u3640\0\370\0\u367e\0\u36bc\0\u36fa\0\u3738\0\u3776"+
    "\0\u37b4\0\u37f2\0\u3830\0\u386e\0\u38ac\0\u38ea\0\u3928\0\u3966"+
    "\0\u39a4\0\u39e2\0\u3a20\0\u3a5e\0\u3a9c\0\u3ada\0\u3b18\0\u38ea"+
    "\0\u3b56\0\u3b94\0\u3bd2\0\u3c10\0\u3c4e\0\u1496\0\u3c8c\0\u3cca"+
    "\0\u3d08\0\u3d46\0\u3d84\0\u3dc2";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[276];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\2\5\1\6\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\4\1\16\1\5\1\17\1\20\1\5"+
    "\1\6\1\21\1\5\1\22\1\23\1\5\1\24\2\5"+
    "\1\25\1\4\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\5\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\46\1\47\1\50\1\51\1\52"+
    "\1\53\1\54\1\55\1\56\1\57\1\55\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\10\66\1\67\65\66\11\70"+
    "\1\71\64\70\77\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\25\5\13\0\3\72\1\6\4\72"+
    "\3\0\1\72\2\73\1\6\2\72\1\6\2\72\1\74"+
    "\2\75\1\0\2\76\1\72\1\0\1\72\1\0\25\72"+
    "\14\0\7\5\1\13\1\14\2\0\10\5\1\0\1\77"+
    "\1\5\1\0\2\5\4\0\1\100\7\5\1\101\14\5"+
    "\14\0\3\5\1\11\1\5\1\11\1\5\1\13\1\14"+
    "\2\0\10\5\1\0\2\5\1\0\2\5\4\0\1\5"+
    "\1\102\23\5\14\0\7\5\1\13\1\14\2\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\3\5"+
    "\1\11\1\5\1\11\1\5\1\13\1\14\2\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\13\0\10\103"+
    "\1\104\1\103\1\0\1\105\62\103\11\106\1\107\1\0"+
    "\1\110\62\106\1\0\7\5\4\0\10\5\1\0\1\111"+
    "\1\5\1\0\2\5\4\0\1\112\7\5\1\113\1\114"+
    "\13\5\13\0\3\72\1\115\4\72\3\0\1\72\2\73"+
    "\1\116\2\117\1\116\2\72\1\74\2\75\1\0\2\76"+
    "\1\72\1\0\1\72\1\0\25\72\14\0\3\5\1\120"+
    "\3\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\25\5\14\0\3\5\1\121\3\5\4\0\1\122\7\5"+
    "\1\0\2\5\1\0\2\5\4\0\10\5\1\123\1\124"+
    "\13\5\16\0\1\74\12\0\1\74\2\0\1\74\55\0"+
    "\7\5\4\0\1\125\2\5\1\126\4\5\1\0\2\5"+
    "\1\0\2\5\4\0\1\5\1\127\16\5\1\130\4\5"+
    "\42\0\1\60\34\0\1\60\12\0\2\131\1\0\4\131"+
    "\4\0\2\131\1\0\2\131\1\0\2\131\1\0\2\131"+
    "\1\0\2\131\4\0\25\131\13\0\12\26\1\0\63\26"+
    "\35\0\1\27\41\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\1\5\1\132\1\5\1\133\1\5"+
    "\1\134\4\5\1\135\12\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\10\5\1\136\14\5"+
    "\14\0\7\5\4\0\10\5\1\0\1\137\1\5\1\0"+
    "\2\5\4\0\10\5\1\140\1\141\13\5\14\0\4\5"+
    "\1\142\2\5\4\0\1\143\7\5\1\0\1\144\1\5"+
    "\1\0\2\5\4\0\4\5\1\145\4\5\1\146\5\5"+
    "\1\147\5\5\14\0\3\5\1\150\1\151\2\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\13\5\1\152"+
    "\11\5\14\0\3\5\1\153\1\154\2\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\10\5\1\155\14\5"+
    "\14\0\7\5\4\0\1\156\7\5\1\0\2\5\1\0"+
    "\2\5\4\0\1\157\7\5\1\160\3\5\1\161\2\5"+
    "\1\162\5\5\14\0\3\5\1\163\3\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\5\5\1\164\1\5"+
    "\1\165\2\5\1\166\12\5\14\0\7\5\4\0\6\5"+
    "\1\167\1\5\1\0\2\5\1\0\2\5\4\0\1\5"+
    "\1\170\1\171\1\172\1\173\7\5\1\174\10\5\14\0"+
    "\3\5\1\175\3\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\1\176\7\5\1\177\14\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\11\5"+
    "\1\200\13\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\1\201\10\5\1\111\13\5\14\0"+
    "\7\5\4\0\1\202\7\5\1\0\1\144\1\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\17\5\1\203\5\5\14\0"+
    "\7\5\4\0\10\5\1\0\1\204\1\5\1\0\2\5"+
    "\4\0\1\205\24\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\1\206\7\5\1\207\14\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\11\5\1\161\13\5\14\0\3\5\1\210\3\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\1\211\24\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\10\5\1\212\14\5\77\0"+
    "\1\60\75\0\2\60\74\0\1\60\1\0\1\60\100\0"+
    "\1\55\76\0\1\55\76\0\1\60\76\0\1\60\1\0"+
    "\10\66\1\0\65\66\10\0\1\213\65\0\11\70\1\0"+
    "\64\70\11\0\1\214\64\0\10\72\3\0\11\72\1\0"+
    "\2\72\1\0\3\72\1\0\1\72\1\0\25\72\16\0"+
    "\1\74\12\0\1\74\2\0\1\74\3\0\2\215\1\0"+
    "\2\216\44\0\3\72\1\217\4\72\3\0\3\72\1\217"+
    "\2\72\1\217\2\72\1\0\2\72\1\220\3\72\1\0"+
    "\1\72\1\0\25\72\2\0\1\220\11\0\7\5\4\0"+
    "\1\221\7\5\1\0\2\5\1\0\2\5\4\0\2\5"+
    "\1\222\1\5\1\223\5\5\1\224\12\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\1\5"+
    "\1\225\7\5\1\226\4\5\1\227\6\5\14\0\4\5"+
    "\1\230\2\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\25\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\3\5\1\231\5\5\1\232\13\5"+
    "\13\0\10\103\1\233\1\103\1\0\1\105\62\103\10\0"+
    "\1\234\65\0\12\103\1\0\63\103\11\106\1\233\1\0"+
    "\1\110\62\106\11\0\1\235\64\0\12\106\1\0\63\106"+
    "\1\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\1\5\1\171\23\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\14\5\1\236\10\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\1\5\1\237\5\5\1\240\15\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\3\5"+
    "\1\165\21\5\13\0\3\72\1\115\4\72\3\0\3\72"+
    "\1\115\2\72\1\115\2\72\1\74\2\75\1\0\2\76"+
    "\1\72\1\0\1\72\1\0\25\72\13\0\3\72\1\115"+
    "\4\72\3\0\1\72\2\73\1\116\2\72\1\116\2\72"+
    "\1\74\2\75\1\0\2\76\1\72\1\0\1\72\1\0"+
    "\25\72\13\0\3\72\1\241\4\72\3\0\3\72\1\241"+
    "\2\72\3\241\1\0\2\241\1\0\3\72\1\0\1\72"+
    "\1\0\1\241\1\72\1\241\2\72\1\241\1\72\1\241"+
    "\13\72\1\241\1\72\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\1\242\24\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\10\5"+
    "\1\243\14\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\10\5\1\244\14\5\14\0\3\5"+
    "\1\167\3\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\25\5\14\0\7\5\4\0\1\245\7\5\1\0"+
    "\2\5\1\0\2\5\4\0\1\5\1\246\23\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\3\5\1\247\5\5\1\250\13\5\14\0\7\5\4\0"+
    "\10\5\1\0\1\251\1\5\1\0\2\5\4\0\7\5"+
    "\1\252\15\5\14\0\4\5\1\253\2\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\1\254"+
    "\24\5\14\0\7\131\4\0\10\131\1\0\2\131\1\0"+
    "\2\131\4\0\25\131\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\2\5\1\167\22\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\3\5\1\255\21\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\3\5\1\171\21\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\12\5\1\256\12\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\4\5\1\167\20\5\14\0"+
    "\7\5\4\0\1\257\5\5\1\167\1\5\1\0\2\5"+
    "\1\0\2\5\4\0\25\5\14\0\4\5\1\260\2\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\3\5\1\171\3\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\7\5\1\165\10\5\1\261\4\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\12\5\1\173\1\5\1\171\10\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\11\5"+
    "\1\262\13\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\4\5\1\263\20\5\14\0\3\5"+
    "\1\171\3\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\1\264\24\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\15\5\1\265\7\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\10\5\1\266\14\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\13\5\1\167\11\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\12\5\1\267\12\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\12\5\1\270\12\5\14\0"+
    "\7\5\4\0\10\5\1\0\1\271\1\5\1\0\2\5"+
    "\4\0\25\5\14\0\7\5\4\0\6\5\1\272\1\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\10\5"+
    "\1\254\14\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\1\273\24\5\14\0\7\5\4\0"+
    "\1\274\7\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\7\5\4\0\10\5\1\0\1\275\1\5\1\0"+
    "\2\5\4\0\1\5\1\276\12\5\1\277\10\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\12\5\1\171\12\5\14\0\3\5\1\171\3\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\1\300\24\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\2\5\1\171\22\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\1\301\1\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\4\5\1\171\20\5\14\0\7\5\4\0\10\5\1\0"+
    "\1\111\1\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\4\5"+
    "\1\302\5\5\1\303\12\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\3\5\1\304\5\5"+
    "\1\305\13\5\14\0\7\5\4\0\10\5\1\0\1\224"+
    "\1\5\1\0\2\5\4\0\25\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\12\5\1\306"+
    "\12\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\10\5\1\307\1\310\13\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\3\5"+
    "\1\311\21\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\16\5\1\171\6\5\14\0\7\5"+
    "\4\0\10\5\1\0\1\312\1\5\1\0\2\5\4\0"+
    "\25\5\14\0\7\5\4\0\3\5\1\171\4\5\1\0"+
    "\2\5\1\0\2\5\4\0\12\5\1\171\12\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\10\5\1\313\14\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\11\5\1\314\13\5\14\0"+
    "\7\5\4\0\3\5\1\171\4\5\1\0\2\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\3\5\1\315\21\5\14\0"+
    "\3\5\1\134\3\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\11\5\1\316\13\5\14\0"+
    "\4\5\1\317\2\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\1\320\7\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\1\5"+
    "\1\317\23\5\23\0\1\321\76\0\1\322\67\0\1\323"+
    "\12\0\1\323\2\0\1\323\5\0\1\220\35\0\1\220"+
    "\10\0\3\72\1\217\4\72\3\0\3\72\1\217\2\72"+
    "\1\217\2\72\1\0\2\72\1\0\2\76\1\72\1\0"+
    "\1\72\1\0\25\72\16\0\1\323\12\0\1\323\2\0"+
    "\1\323\55\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\10\5\1\324\14\5\14\0\4\5\1\262"+
    "\2\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\25\5\14\0\4\5\1\325\2\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\25\5\14\0\3\5\1\171"+
    "\3\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\25\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\15\5\1\270\7\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\3\5\1\247"+
    "\21\5\14\0\1\326\6\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\25\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\1\5\1\327\23\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\11\5\1\146\13\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\7\5\1\330\15\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\5\5\1\331\17\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\15\5\1\332\7\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\1\333\24\5\13\0\3\72\1\241\4\72\3\0"+
    "\1\72\2\73\1\241\2\72\3\241\1\0\2\241\1\0"+
    "\3\72\1\0\1\72\1\0\1\241\1\72\1\241\2\72"+
    "\1\241\1\72\1\241\13\72\1\241\1\72\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\1\5"+
    "\1\225\23\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\14\5\1\167\10\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\1\334"+
    "\24\5\14\0\7\5\4\0\10\5\1\0\1\171\1\5"+
    "\1\0\2\5\4\0\4\5\1\173\20\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\1\335"+
    "\24\5\14\0\7\5\4\0\10\5\1\0\1\167\1\5"+
    "\1\0\2\5\4\0\25\5\14\0\7\5\4\0\6\5"+
    "\1\167\1\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\7\5\1\336\15\5\14\0\7\5\4\0\10\5"+
    "\1\0\1\337\1\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\14\5\1\340\10\5\14\0\7\5\4\0\1\171\7\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\1\341\1\5\1\0\2\5\4\0"+
    "\25\5\14\0\7\5\4\0\1\342\7\5\1\0\2\5"+
    "\1\0\2\5\4\0\25\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\1\343\24\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\5\5\1\344\17\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\14\5\1\345\10\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\7\5\1\270\15\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\4\5\1\346\20\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\1\5\1\347\23\5\14\0\3\5\1\334\3\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\1\270\7\5\1\0\2\5\1\0\2\5"+
    "\4\0\25\5\14\0\7\5\4\0\10\5\1\0\1\171"+
    "\1\5\1\0\2\5\4\0\25\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\1\350\24\5"+
    "\14\0\7\5\4\0\6\5\1\173\1\5\1\0\2\5"+
    "\1\0\2\5\4\0\25\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\3\5\1\351\21\5"+
    "\14\0\7\5\4\0\1\352\7\5\1\0\2\5\1\0"+
    "\2\5\4\0\25\5\14\0\3\5\1\262\3\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\4\5\1\353\20\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\12\5\1\354\12\5\14\0"+
    "\3\5\1\332\3\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\10\5\1\0"+
    "\1\355\1\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\1\356\1\5\1\0\2\5\4\0"+
    "\25\5\14\0\4\5\1\165\2\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\25\5\14\0\4\5\1\357"+
    "\2\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\25\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\1\5\1\360\23\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\10\5\1\341"+
    "\14\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\12\5\1\361\12\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\1\5\1\136"+
    "\23\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\3\5\1\167\21\5\14\0\7\5\4\0"+
    "\1\132\7\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\5\5\1\362\17\5\14\0\7\5\4\0\1\247"+
    "\7\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\1\343\16\5\1\171\5\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\2\5\1\332\22\5"+
    "\14\0\7\5\4\0\10\5\1\0\1\363\1\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\3\5\1\317\21\5\16\0"+
    "\1\323\12\0\1\323\2\0\1\323\6\0\2\216\45\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\1\327\24\5\14\0\3\5\1\364\3\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\11\5"+
    "\1\365\13\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\10\5\1\366\6\5\1\224\5\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\2\5\1\367\22\5\14\0\7\5\4\0\1\134"+
    "\7\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\4\5\1\332\20\5\14\0\7\5\4\0\1\370\7\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\6\5\1\371\1\5\1\0\2\5\1\0\2\5"+
    "\4\0\25\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\12\5\1\136\12\5\14\0\7\5"+
    "\4\0\10\5\1\0\1\372\1\5\1\0\2\5\4\0"+
    "\25\5\14\0\3\5\1\136\3\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\25\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\13\5\1\171"+
    "\11\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\4\5\1\373\20\5\14\0\7\5\4\0"+
    "\1\374\7\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\10\5\1\327\14\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\11\5\1\375\13\5"+
    "\14\0\7\5\4\0\10\5\1\0\1\316\1\5\1\0"+
    "\2\5\4\0\25\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\6\5\1\167\16\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\3\5\1\376\21\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\1\377\24\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\11\5"+
    "\1\u0100\13\5\14\0\7\5\4\0\1\u0101\7\5\1\0"+
    "\2\5\1\0\2\5\4\0\11\5\1\267\13\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\7\5\1\165\15\5\14\0\3\5\1\111\3\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\5\5\1\u0102\17\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\3\5\1\u0103\21\5\14\0"+
    "\7\5\4\0\10\5\1\0\1\u0104\1\5\1\0\2\5"+
    "\4\0\25\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\1\u0105\24\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\1\5\1\167"+
    "\23\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\1\5\1\u0106\23\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\2\5\1\270"+
    "\22\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\1\167\24\5\14\0\7\5\4\0\1\150"+
    "\7\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\11\5\1\267\13\5\14\0\3\5\1\u0107\3\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\25\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\4\5\1\224\20\5\14\0\7\5\4\0\10\5\1\0"+
    "\1\332\1\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\7\5"+
    "\1\u0108\15\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\14\5\1\u0109\10\5\14\0\7\5"+
    "\4\0\10\5\1\0\2\5\1\0\2\5\4\0\5\5"+
    "\1\267\17\5\14\0\7\5\4\0\10\5\1\0\2\5"+
    "\1\0\2\5\4\0\1\5\1\u010a\23\5\14\0\7\5"+
    "\4\0\10\5\1\0\1\204\1\5\1\0\2\5\4\0"+
    "\25\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\7\5\1\u010b\15\5\14\0\7\5\4\0"+
    "\10\5\1\0\2\5\1\0\2\5\4\0\4\5\1\u010c"+
    "\20\5\14\0\3\5\1\u010d\3\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\25\5\14\0\7\5\4\0"+
    "\1\u010e\7\5\1\0\2\5\1\0\2\5\4\0\25\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\12\5\1\303\12\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\1\u010f\24\5\14\0"+
    "\7\5\4\0\10\5\1\0\1\u0110\1\5\1\0\2\5"+
    "\4\0\25\5\14\0\4\5\1\247\2\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\25\5\14\0\7\5"+
    "\4\0\1\u0111\7\5\1\0\2\5\1\0\2\5\4\0"+
    "\25\5\14\0\7\5\4\0\10\5\1\0\2\5\1\0"+
    "\2\5\4\0\1\u0112\24\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\4\5\1\342\20\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\4\5\1\270\20\5\14\0\7\5\4\0\10\5"+
    "\1\0\2\5\1\0\2\5\4\0\4\5\1\u0113\20\5"+
    "\14\0\7\5\4\0\10\5\1\0\2\5\1\0\2\5"+
    "\4\0\1\u0114\24\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\1\5\1\262\23\5\14\0"+
    "\7\5\4\0\10\5\1\0\2\5\1\0\2\5\4\0"+
    "\17\5\1\345\5\5\14\0\7\5\4\0\10\5\1\0"+
    "\2\5\1\0\2\5\4\0\3\5\1\134\21\5\13\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[15872];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\11\10\1\1\11\36\1\1\11\3\1\1\11"+
    "\4\1\1\11\17\1\1\0\2\1\1\0\102\1\3\0"+
    "\1\11\1\1\1\0\12\1\3\11\63\1\2\11\102\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[276];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public PythonTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "#", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	@Override
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = LONG_STRING_2;
				break;
			case Token.LITERAL_CHAR:
				state = LONG_STRING_1;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PythonTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PythonTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 174) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = zzLexicalState;


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 5:
          { addNullToken(); return firstToken;
          }
        case 22: break;
        case 10:
          { addToken(Token.LITERAL_CHAR);
          }
        case 23: break;
        case 8:
          { addToken(Token.WHITESPACE);
          }
        case 24: break;
        case 12:
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 25: break;
        case 14:
          { addToken(Token.RESERVED_WORD);
          }
        case 26: break;
        case 9:
          { addToken(Token.SEPARATOR);
          }
        case 27: break;
        case 16:
          { yybegin(LONG_STRING_1); addToken(Token.LITERAL_CHAR);
          }
        case 28: break;
        case 2:
          { addToken(Token.IDENTIFIER);
          }
        case 29: break;
        case 15:
          { addToken(Token.FUNCTION);
          }
        case 30: break;
        case 18:
          { addToken(Token.DATA_TYPE);
          }
        case 31: break;
        case 1:
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 32: break;
        case 13:
          { addToken(Token.ANNOTATION);
          }
        case 33: break;
        case 4:
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 34: break;
        case 21:
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 35: break;
        case 7:
          { addToken(Token.COMMENT_EOL);
          }
        case 36: break;
        case 11:
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 37: break;
        case 3:
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 38: break;
        case 6:
          { addToken(Token.OPERATOR);
          }
        case 39: break;
        case 20:
          { yybegin(YYINITIAL); addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 40: break;
        case 17:
          { yybegin(LONG_STRING_2); addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 41: break;
        case 19:
          { yybegin(YYINITIAL); addToken(Token.LITERAL_CHAR);
          }
        case 42: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 277: break;
            case LONG_STRING_2: {
              if (firstToken==null) {
										addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
									}
									return firstToken;
            }
            case 278: break;
            case LONG_STRING_1: {
              if (firstToken==null) {
										addToken(Token.LITERAL_CHAR);
									}
									return firstToken;
            }
            case 279: break;
            default:
            return null;
            }
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
