/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.security.token;

import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class JWTEncoder {
    private static final String TOKEN_SEP = ".";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String HMAC_256 = "HmacSHA256";

    public static String encode(JSONObject claims, String secret) {
        String encodedHeader = JWTEncoder.getCommonHeader();
        String encodedClaims = JWTEncoder.encodeJson(claims);
        String secureBits = encodedHeader + TOKEN_SEP + encodedClaims;
        String sig = JWTEncoder.sign(secret, secureBits);
        return secureBits + TOKEN_SEP + sig;
    }

    private static String sign(String secret, String secureBits) {
        String result = null;
        try {
            Mac sha256_HMAC = Mac.getInstance(HMAC_256);
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(UTF8_CHARSET), HMAC_256);
            sha256_HMAC.init(secret_key);
            byte[] sig = sha256_HMAC.doFinal(secureBits.getBytes(UTF8_CHARSET));
            result = Base64.encodeBase64URLSafeString((byte[])sig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getCommonHeader() {
        JSONObject headerJson = new JSONObject();
        try {
            headerJson.put("typ", (Object)"JWT");
            headerJson.put("alg", (Object)"HS256");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return JWTEncoder.encodeJson(headerJson);
    }

    private static String encodeJson(JSONObject jsonData) {
        return Base64.encodeBase64URLSafeString((byte[])jsonData.toString().getBytes(UTF8_CHARSET));
    }
}

