/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.security.token;

import com.firebase.security.token.JWTEncoder;
import com.firebase.security.token.TokenOptions;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenGenerator {
    private static final int TOKEN_VERSION = 0;
    private String firebaseSecret;

    public TokenGenerator(String firebaseSecret) {
        this.firebaseSecret = firebaseSecret;
    }

    public String createToken(JSONObject data) {
        return this.createToken(data, new TokenOptions());
    }

    public String createToken(JSONObject data, TokenOptions options) {
        if (!(data != null && data.length() != 0 || options != null && (options.isAdmin() || options.isDebug()))) {
            throw new IllegalArgumentException("TokenGenerator.createToken: data is empty and no options are set.  This token will have no effect on Firebase.");
        }
        JSONObject claims = new JSONObject();
        try {
            claims.put("v", 0);
            claims.put("iat", new Date().getTime() / 1000L);
            if (data != null && data.length() > 0) {
                claims.put("d", (Object)data);
            }
            if (options != null) {
                if (options.getExpires() != null) {
                    claims.put("exp", options.getExpires().getTime() / 1000L);
                }
                if (options.getNotBefore() != null) {
                    claims.put("nbf", options.getNotBefore().getTime() / 1000L);
                }
                if (options.isAdmin()) {
                    claims.put("admin", options.isAdmin());
                }
                if (options.isDebug()) {
                    claims.put("debug", options.isDebug());
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.computeToken(claims);
    }

    private String computeToken(JSONObject claims) {
        return JWTEncoder.encode(claims, this.firebaseSecret);
    }
}

