/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.guava.common.collect;

import com.fitbur.guava.common.annotations.GwtCompatible;
import com.fitbur.guava.common.annotations.GwtIncompatible;
import com.fitbur.guava.common.collect.ImmutableAsList;
import com.fitbur.guava.common.collect.ImmutableCollection;
import com.fitbur.guava.common.collect.ImmutableList;
import com.fitbur.guava.common.collect.UnmodifiableListIterator;
import com.fitbur.guava.j2objc.annotations.Weak;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    @Weak
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible(value="not present in emulated superclass")
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

