/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.junit.core;

import com.fitbur.testify.TestContext;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.model.MultipleFailureException;
import org.slf4j.Logger;

public class JUnitTestNotifier
extends RunNotifier {
    private final RunNotifier notifier;
    private final Description description;
    private final Logger logger;
    private final TestContext testContext;

    public JUnitTestNotifier(RunNotifier runNotifier, Description description, Logger logger, TestContext testContext) {
        this.notifier = runNotifier;
        this.description = description;
        this.logger = logger;
        this.testContext = testContext;
    }

    public void fireTestAssumptionFailed(Failure failure) {
        String string = failure.getDescription().getClassName();
        String string2 = failure.getDescription().getMethodName();
        if (string2 == null) {
            this.logger.error("Test Class {} Failed", (Object)string);
        } else {
            this.logger.error("Test Method '{}' Failed", (Object)string2);
        }
        this.notifier.fireTestAssumptionFailed(failure);
    }

    public void fireTestFailure(Failure failure) {
        String string = failure.getDescription().getClassName();
        String string2 = failure.getDescription().getMethodName();
        if (string2 == null) {
            this.logger.error("Test Class {} Failed", (Object)string);
        } else {
            this.logger.error("Test Method '{}' Failed", (Object)string2);
        }
        this.notifier.fireTestFailure(failure);
    }

    public void fireTestIgnored(Description description) {
        this.logger.warn("Ignored {}", (Object)description.getMethodName());
        this.notifier.fireTestIgnored(description);
    }

    public void fireTestStarted(Description description) throws StoppedByUserException {
        this.logger.info("Running {}", (Object)description.getMethodName());
        this.notifier.fireTestStarted(description);
    }

    public void fireTestFinished(Description description) {
        this.logger.debug("Finished {}", (Object)description.getMethodName());
        this.notifier.fireTestFinished(description);
    }

    public void addFailure(Throwable throwable) {
        if (throwable instanceof MultipleFailureException) {
            this.addMultipleFailureException((MultipleFailureException)throwable);
        } else {
            this.notifier.fireTestFailure(new Failure(this.description, throwable));
        }
    }

    private void addMultipleFailureException(MultipleFailureException multipleFailureException) {
        multipleFailureException.getFailures().stream().forEach(throwable -> this.addFailure((Throwable)throwable));
    }

    public void addFailedAssumption(AssumptionViolatedException assumptionViolatedException) {
        this.notifier.fireTestAssumptionFailed(new Failure(this.description, (Throwable)assumptionViolatedException));
    }
}

