/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.AppCredentialSignedjwtSigningKeys;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Configuration for signed JWT authentication.")
public class AuthConfigSignedJWT {
    @JsonProperty(value="valid_issuers")
    private List<String> validIssuers = new ArrayList<String>();
    @JsonProperty(value="signing_keys")
    private AppCredentialSignedjwtSigningKeys signingKeys = null;

    public AuthConfigSignedJWT validIssuers(List<String> validIssuers) {
        this.validIssuers = validIssuers;
        return this;
    }

    public AuthConfigSignedJWT addValidIssuersItem(String validIssuersItem) {
        this.validIssuers.add(validIssuersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of valid issuers. JWT presented for authentication must have one of these issuers.")
    @JsonProperty(value="valid_issuers")
    public List<String> getValidIssuers() {
        return this.validIssuers;
    }

    @JsonProperty(value="valid_issuers")
    public void setValidIssuers(List<String> validIssuers) {
        this.validIssuers = validIssuers;
    }

    public AuthConfigSignedJWT signingKeys(AppCredentialSignedjwtSigningKeys signingKeys) {
        this.signingKeys = signingKeys;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="signing_keys")
    public AppCredentialSignedjwtSigningKeys getSigningKeys() {
        return this.signingKeys;
    }

    @JsonProperty(value="signing_keys")
    public void setSigningKeys(AppCredentialSignedjwtSigningKeys signingKeys) {
        this.signingKeys = signingKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfigSignedJWT authConfigSignedJWT = (AuthConfigSignedJWT)o;
        return Objects.equals(this.validIssuers, authConfigSignedJWT.validIssuers) && Objects.equals(this.signingKeys, authConfigSignedJWT.signingKeys);
    }

    public int hashCode() {
        return Objects.hash(this.validIssuers, this.signingKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthConfigSignedJWT {\n");
        sb.append("    validIssuers: ").append(this.toIndentedString(this.validIssuers)).append("\n");
        sb.append("    signingKeys: ").append(this.toIndentedString(this.signingKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

