/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class CipherMode {
    private String value;
    public static final CipherMode ECB = new CipherMode("ECB");
    public static final CipherMode CBC = new CipherMode("CBC");
    public static final CipherMode CBCNOPAD = new CipherMode("CBCNOPAD");
    public static final CipherMode CFB = new CipherMode("CFB");
    public static final CipherMode OFB = new CipherMode("OFB");
    public static final CipherMode CTR = new CipherMode("CTR");
    public static final CipherMode GCM = new CipherMode("GCM");
    public static final CipherMode CCM = new CipherMode("CCM");
    public static final CipherMode KW = new CipherMode("KW");
    public static final CipherMode KWP = new CipherMode("KWP");
    private static final Map<String, CipherMode> valueMap = new HashMap<String, CipherMode>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private CipherMode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CipherMode[] values() {
        valueMapLock.lock();
        try {
            CipherMode[] cipherModeArray = valueMap.values().toArray(new CipherMode[valueMap.values().size()]);
            return cipherModeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static CipherMode fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                CipherMode cipherMode = valueMap.get(val);
                return cipherMode;
            }
            CipherMode newValue = new CipherMode(val);
            valueMap.put(val, newValue);
            CipherMode cipherMode = newValue;
            return cipherMode;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("ECB", ECB);
        valueMap.put("CBC", CBC);
        valueMap.put("CBCNOPAD", CBCNOPAD);
        valueMap.put("CFB", CFB);
        valueMap.put("OFB", OFB);
        valueMap.put("CTR", CTR);
        valueMap.put("GCM", GCM);
        valueMap.put("CCM", CCM);
        valueMap.put("KW", KW);
        valueMap.put("KWP", KWP);
    }
}

