/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CipherMode;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="All requests must have exactly one \"init\" frame, sent before any other frames. ")
public class DecryptRequestFrameInit {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="mode")
    private CipherMode mode = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;

    public DecryptRequestFrameInit key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public DecryptRequestFrameInit mode(CipherMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="mode")
    public CipherMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CipherMode mode) {
        this.mode = mode;
    }

    public DecryptRequestFrameInit iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="The initialization vector used to encrypt this ciphertext.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string.  This field is required for all modes except ECB, where it is forbidden. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecryptRequestFrameInit decryptRequestFrameInit = (DecryptRequestFrameInit)o;
        return Objects.equals(this.key, decryptRequestFrameInit.key) && Objects.equals(this.mode, decryptRequestFrameInit.mode) && Objects.equals(this.iv, decryptRequestFrameInit.iv);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.mode, this.iv);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecryptRequestFrameInit {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

