/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.DecryptResponseFrameInit;
import com.fortanix.sdkms.v1.model.EncryptResponseFrameError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A single frame of an decrypt response.  Each frame is a CBOR map with exactly one string key: \"init\", \"plain\", \"final\", or \"error\". ")
public class DecryptResponseFrame {
    @JsonProperty(value="init")
    private DecryptResponseFrameInit init = null;
    @JsonProperty(value="plain")
    private byte[] plain = null;
    @JsonProperty(value="final")
    private Object _final = null;
    @JsonProperty(value="error")
    private EncryptResponseFrameError error = null;

    public DecryptResponseFrame init(DecryptResponseFrameInit init) {
        this.init = init;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="init")
    public DecryptResponseFrameInit getInit() {
        return this.init;
    }

    @JsonProperty(value="init")
    public void setInit(DecryptResponseFrameInit init) {
        this.init = init;
    }

    public DecryptResponseFrame plain(byte[] plain) {
        this.plain = plain;
        return this;
    }

    @ApiModelProperty(value="A chunk of plaintext.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string. ")
    @JsonProperty(value="plain")
    public byte[] getPlain() {
        return this.plain;
    }

    @JsonProperty(value="plain")
    public void setPlain(byte[] plain) {
        this.plain = plain;
    }

    public DecryptResponseFrame _final(Object _final) {
        this._final = _final;
        return this;
    }

    @ApiModelProperty(value="The response ends with a single \"final\" frame, indicating success. ")
    @JsonProperty(value="final")
    public Object getFinal() {
        return this._final;
    }

    @JsonProperty(value="final")
    public void setFinal(Object _final) {
        this._final = _final;
    }

    public DecryptResponseFrame error(EncryptResponseFrameError error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="error")
    public EncryptResponseFrameError getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    public void setError(EncryptResponseFrameError error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecryptResponseFrame decryptResponseFrame = (DecryptResponseFrame)o;
        return Objects.equals(this.init, decryptResponseFrame.init) && Objects.equals(this.plain, decryptResponseFrame.plain) && Objects.equals(this._final, decryptResponseFrame._final) && Objects.equals(this.error, decryptResponseFrame.error);
    }

    public int hashCode() {
        return Objects.hash(this.init, this.plain, this._final, this.error);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecryptResponseFrame {\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    plain: ").append(this.toIndentedString(this.plain)).append("\n");
        sb.append("    _final: ").append(this.toIndentedString(this._final)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

