/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class EllipticCurve {
    private String value;
    public static final EllipticCurve SECP192K1 = new EllipticCurve("SecP192K1");
    public static final EllipticCurve SECP224K1 = new EllipticCurve("SecP224K1");
    public static final EllipticCurve SECP256K1 = new EllipticCurve("SecP256K1");
    public static final EllipticCurve NISTP192 = new EllipticCurve("NistP192");
    public static final EllipticCurve NISTP224 = new EllipticCurve("NistP224");
    public static final EllipticCurve NISTP256 = new EllipticCurve("NistP256");
    public static final EllipticCurve NISTP384 = new EllipticCurve("NistP384");
    public static final EllipticCurve NISTP521 = new EllipticCurve("NistP521");
    public static final EllipticCurve GOST256A = new EllipticCurve("Gost256A");
    public static final EllipticCurve ED25519 = new EllipticCurve("Ed25519");
    public static final EllipticCurve X25519 = new EllipticCurve("X25519");
    public static final EllipticCurve X448 = new EllipticCurve("X448");
    private static final Map<String, EllipticCurve> valueMap = new HashMap<String, EllipticCurve>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private EllipticCurve(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EllipticCurve[] values() {
        valueMapLock.lock();
        try {
            EllipticCurve[] ellipticCurveArray = valueMap.values().toArray(new EllipticCurve[valueMap.values().size()]);
            return ellipticCurveArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static EllipticCurve fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                EllipticCurve ellipticCurve = valueMap.get(val);
                return ellipticCurve;
            }
            EllipticCurve newValue = new EllipticCurve(val);
            valueMap.put(val, newValue);
            EllipticCurve ellipticCurve = newValue;
            return ellipticCurve;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("SecP192K1", SECP192K1);
        valueMap.put("SecP224K1", SECP224K1);
        valueMap.put("SecP256K1", SECP256K1);
        valueMap.put("NistP192", NISTP192);
        valueMap.put("NistP224", NISTP224);
        valueMap.put("NistP256", NISTP256);
        valueMap.put("NistP384", NISTP384);
        valueMap.put("NistP521", NISTP521);
        valueMap.put("Gost256A", GOST256A);
        valueMap.put("Ed25519", ED25519);
        valueMap.put("X25519", X25519);
        valueMap.put("X448", X448);
    }
}

