/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.EncryptRequestFrameInit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A single frame of an encrypt request.  Each frame is a CBOR map with exactly one string key: \"init\", \"ad\", \"plain\", or \"final\". ")
public class EncryptRequestFrame {
    @JsonProperty(value="init")
    private EncryptRequestFrameInit init = null;
    @JsonProperty(value="ad")
    private byte[] ad = null;
    @JsonProperty(value="plain")
    private byte[] plain = null;
    @JsonProperty(value="final")
    private Object _final = null;

    public EncryptRequestFrame init(EncryptRequestFrameInit init) {
        this.init = init;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="init")
    public EncryptRequestFrameInit getInit() {
        return this.init;
    }

    @JsonProperty(value="init")
    public void setInit(EncryptRequestFrameInit init) {
        this.init = init;
    }

    public EncryptRequestFrame ad(byte[] ad) {
        this.ad = ad;
        return this;
    }

    @ApiModelProperty(value="A chunk of additional data for authentication in AEAD modes.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string.  All \"ad\" frames must come before any \"plain\" frames. ")
    @JsonProperty(value="ad")
    public byte[] getAd() {
        return this.ad;
    }

    @JsonProperty(value="ad")
    public void setAd(byte[] ad) {
        this.ad = ad;
    }

    public EncryptRequestFrame plain(byte[] plain) {
        this.plain = plain;
        return this;
    }

    @ApiModelProperty(value="A chunk of ciphertext.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string.  In addition to the 512 KiB limit on the total size of all frames, the content of this field may be at most 511 KiB. ")
    @JsonProperty(value="plain")
    public byte[] getPlain() {
        return this.plain;
    }

    @JsonProperty(value="plain")
    public void setPlain(byte[] plain) {
        this.plain = plain;
    }

    public EncryptRequestFrame _final(Object _final) {
        this._final = _final;
        return this;
    }

    @ApiModelProperty(value="All requests must end with a \"final\" frame.  The value is the empty object (a CBOR map with zero items). ")
    @JsonProperty(value="final")
    public Object getFinal() {
        return this._final;
    }

    @JsonProperty(value="final")
    public void setFinal(Object _final) {
        this._final = _final;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptRequestFrame encryptRequestFrame = (EncryptRequestFrame)o;
        return Objects.equals(this.init, encryptRequestFrame.init) && Objects.equals(this.ad, encryptRequestFrame.ad) && Objects.equals(this.plain, encryptRequestFrame.plain) && Objects.equals(this._final, encryptRequestFrame._final);
    }

    public int hashCode() {
        return Objects.hash(this.init, this.ad, this.plain, this._final);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptRequestFrame {\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    ad: ").append(this.toIndentedString(this.ad)).append("\n");
        sb.append("    plain: ").append(this.toIndentedString(this.plain)).append("\n");
        sb.append("    _final: ").append(this.toIndentedString(this._final)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

