/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.CipherMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class EncryptRequestFrameInit {
    @JsonProperty(value="key")
    private SobjectDescriptor key = null;
    @JsonProperty(value="mode")
    private CipherMode mode = null;
    @JsonProperty(value="alg")
    private ObjectType alg = null;
    @JsonProperty(value="iv")
    private byte[] iv = null;
    @JsonProperty(value="tag_len")
    private Integer tagLen = null;

    public EncryptRequestFrameInit key(SobjectDescriptor key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="key")
    public SobjectDescriptor getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(SobjectDescriptor key) {
        this.key = key;
    }

    public EncryptRequestFrameInit mode(CipherMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="mode")
    public CipherMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public void setMode(CipherMode mode) {
        this.mode = mode;
    }

    public EncryptRequestFrameInit alg(ObjectType alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="alg")
    public ObjectType getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    public void setAlg(ObjectType alg) {
        this.alg = alg;
    }

    public EncryptRequestFrameInit iv(byte[] iv) {
        this.iv = iv;
        return this;
    }

    @ApiModelProperty(value="The initialization vector to use for encryption.  In CBOR, this is encoded directly as a byte string, *not* a UTF-8 string.  If not provided, one is randomly generated.  If provided, the length must match the length required by the cipher and mode. ")
    @JsonProperty(value="iv")
    public byte[] getIv() {
        return this.iv;
    }

    @JsonProperty(value="iv")
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public EncryptRequestFrameInit tagLen(Integer tagLen) {
        this.tagLen = tagLen;
        return this;
    }

    @ApiModelProperty(value="In AEAD modes, this field specifies the length of the authentication tag to be produced. This field is specified in bits (not bytes). This field is required in AEAD modes, and forbidden otherwise. ")
    @JsonProperty(value="tag_len")
    public Integer getTagLen() {
        return this.tagLen;
    }

    @JsonProperty(value="tag_len")
    public void setTagLen(Integer tagLen) {
        this.tagLen = tagLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptRequestFrameInit encryptRequestFrameInit = (EncryptRequestFrameInit)o;
        return Objects.equals(this.key, encryptRequestFrameInit.key) && Objects.equals(this.mode, encryptRequestFrameInit.mode) && Objects.equals(this.alg, encryptRequestFrameInit.alg) && Objects.equals(this.iv, encryptRequestFrameInit.iv) && Objects.equals(this.tagLen, encryptRequestFrameInit.tagLen);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.mode, this.alg, this.iv, this.tagLen);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptRequestFrameInit {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    iv: ").append(this.toIndentedString(this.iv)).append("\n");
        sb.append("    tagLen: ").append(this.toIndentedString(this.tagLen)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

