/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fortanix.sdkms.v1.model.FpeConstraints;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Structure of a simple tokenized portion of a complex tokenization data type.  ***Implementation note: the parser will try to (locally) match as many characters as possible. (See the description of `FpeDataPart` for more information about why this matters.)*** ")
public class FpeEncryptedPart {
    @JsonProperty(value="min_length")
    private Integer minLength = null;
    @JsonProperty(value="max_length")
    private Integer maxLength = null;
    @JsonProperty(value="char_set")
    private List<List<String>> charSet = new ArrayList<List<String>>();
    @JsonProperty(value="constraints")
    private FpeConstraints constraints = null;

    public FpeEncryptedPart minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @ApiModelProperty(required=true, value="The minimum allowed length for this part (in chars).")
    @JsonProperty(value="min_length")
    public Integer getMinLength() {
        return this.minLength;
    }

    @JsonProperty(value="min_length")
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public FpeEncryptedPart maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @ApiModelProperty(required=true, value="The maximum allowed length for this part (in chars).")
    @JsonProperty(value="max_length")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @JsonProperty(value="max_length")
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public FpeEncryptedPart charSet(List<List<String>> charSet) {
        this.charSet = charSet;
        return this;
    }

    public FpeEncryptedPart addCharSetItem(List<String> charSetItem) {
        this.charSet.add(charSetItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The character set to use for this part.  Characters should be specified as a list of pairs, where each pair [a, b] (example: ['0', '9']) represents the range of Unicode codepoints from a to b, with both bounds being inclusive. A single character can be represented as [c, c] (example: ['/', '/']).  Ranges should not overlap with each other, and should not contain surrogate codepoints.  *Implementation note: normally, each character is assigned a numeric value for FF1, going in the order specified in the array. For instance, in the character set [['a', 'z'], ['0', '9']], the digits from 0 to 9 DO NOT have their usual numeric values; instead, they correspond to the numerals from 26 to 35 (since they come after the 'a' to 'z' range). Note that for practical purposes, this is largely irrelevant, except when specifying a \"numeric\" character set, which MUST contain exactly the digits from 0 to 9, in order. **(When trying to use numeric constraints, it is best to use [[\"0\", \"9\"]] as the character set.)*** ")
    @JsonProperty(value="char_set")
    public List<List<String>> getCharSet() {
        return this.charSet;
    }

    @JsonProperty(value="char_set")
    public void setCharSet(List<List<String>> charSet) {
        this.charSet = charSet;
    }

    public FpeEncryptedPart constraints(FpeConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="constraints")
    public FpeConstraints getConstraints() {
        return this.constraints;
    }

    @JsonProperty(value="constraints")
    public void setConstraints(FpeConstraints constraints) {
        this.constraints = constraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FpeEncryptedPart fpeEncryptedPart = (FpeEncryptedPart)o;
        return Objects.equals(this.minLength, fpeEncryptedPart.minLength) && Objects.equals(this.maxLength, fpeEncryptedPart.maxLength) && Objects.equals(this.charSet, fpeEncryptedPart.charSet) && Objects.equals(this.constraints, fpeEncryptedPart.constraints);
    }

    public int hashCode() {
        return Objects.hash(this.minLength, this.maxLength, this.charSet, this.constraints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FpeEncryptedPart {\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    charSet: ").append(this.toIndentedString(this.charSet)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

