/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ObjectType {
    private String value;
    public static final ObjectType AES = new ObjectType("AES");
    public static final ObjectType DES = new ObjectType("DES");
    public static final ObjectType DES3 = new ObjectType("DES3");
    public static final ObjectType RSA = new ObjectType("RSA");
    public static final ObjectType DSA = new ObjectType("DSA");
    public static final ObjectType EC = new ObjectType("EC");
    public static final ObjectType BLS = new ObjectType("BLS");
    public static final ObjectType OPAQUE = new ObjectType("OPAQUE");
    public static final ObjectType HMAC = new ObjectType("HMAC");
    public static final ObjectType SECRET = new ObjectType("SECRET");
    public static final ObjectType CERTIFICATE = new ObjectType("CERTIFICATE");
    public static final ObjectType ROUND5BETA = new ObjectType("ROUND5BETA");
    public static final ObjectType LEDABETA = new ObjectType("LEDABETA");
    private static final Map<String, ObjectType> valueMap = new HashMap<String, ObjectType>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private ObjectType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectType[] values() {
        valueMapLock.lock();
        try {
            ObjectType[] objectTypeArray = valueMap.values().toArray(new ObjectType[valueMap.values().size()]);
            return objectTypeArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static ObjectType fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                ObjectType objectType = valueMap.get(val);
                return objectType;
            }
            ObjectType newValue = new ObjectType(val);
            valueMap.put(val, newValue);
            ObjectType objectType = newValue;
            return objectType;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("AES", AES);
        valueMap.put("DES", DES);
        valueMap.put("DES3", DES3);
        valueMap.put("RSA", RSA);
        valueMap.put("DSA", DSA);
        valueMap.put("EC", EC);
        valueMap.put("BLS", BLS);
        valueMap.put("OPAQUE", OPAQUE);
        valueMap.put("HMAC", HMAC);
        valueMap.put("SECRET", SECRET);
        valueMap.put("CERTIFICATE", CERTIFICATE);
        valueMap.put("ROUND5BETA", ROUND5BETA);
        valueMap.put("LEDABETA", LEDABETA);
    }
}

