/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class SplittingMethod {
    private String value;
    public static final SplittingMethod XOR = new SplittingMethod("XOR");
    private static final Map<String, SplittingMethod> valueMap = new HashMap<String, SplittingMethod>();
    private static final ReentrantLock valueMapLock = new ReentrantLock();

    private SplittingMethod(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SplittingMethod[] values() {
        valueMapLock.lock();
        try {
            SplittingMethod[] splittingMethodArray = valueMap.values().toArray(new SplittingMethod[valueMap.values().size()]);
            return splittingMethodArray;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    @JsonCreator
    public static SplittingMethod fromValue(String val) {
        valueMapLock.lock();
        try {
            if (valueMap.containsKey(val)) {
                SplittingMethod splittingMethod = valueMap.get(val);
                return splittingMethod;
            }
            SplittingMethod newValue = new SplittingMethod(val);
            valueMap.put(val, newValue);
            SplittingMethod splittingMethod = newValue;
            return splittingMethod;
        }
        finally {
            valueMapLock.unlock();
        }
    }

    static {
        valueMap.put("XOR", XOR);
    }
}

