/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCertificateService;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.v1.model.KeyObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import org.slf4j.LoggerFactory;

public abstract class KeyStore
extends KeyStoreSpi {
    protected static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(KeyStore.class));

    @Override
    public abstract Certificate[] engineGetCertificateChain(String var1);

    @Override
    public abstract Date engineGetCreationDate(String var1);

    @Override
    public abstract void engineSetKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        LOGGER.logAndRaiseProviderException("method setKeyEntry(alias, keyBytes, chain) not supported", null);
    }

    @Override
    public abstract void engineDeleteEntry(String var1) throws KeyStoreException;

    @Override
    public abstract Enumeration<String> engineAliases();

    @Override
    public abstract int engineSize();

    @Override
    public abstract boolean engineIsKeyEntry(String var1);

    @Override
    public abstract boolean engineIsCertificateEntry(String var1);

    @Override
    public abstract String engineGetCertificateAlias(Certificate var1);

    @Override
    public abstract void engineStore(OutputStream var1, char[] var2) throws IOException;

    @Override
    public abstract void engineLoad(InputStream var1, char[] var2) throws IOException;

    @Override
    public abstract void engineSetCertificateEntry(String var1, Certificate var2);

    @Override
    public abstract Key engineGetKey(String var1, char[] var2) throws NoSuchAlgorithmException, UnrecoverableKeyException;

    @Override
    public Certificate engineGetCertificate(String name) {
        LOGGER.debug("Get certificate for alias " + name + " in keystore");
        KeyObject keyObject = null;
        try {
            keyObject = SdkmsKeyService.getSecurityObjectByName(name);
            if (keyObject == null) {
                LOGGER.logAndRaiseProviderException("Invalid certificate received in the request. Cannot retrieve certificate from SDKMS", null);
            }
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "SUN");
            if (keyObject.getValue() == null) {
                return null;
            }
            return certFactory.generateCertificate(new ByteArrayInputStream(keyObject.getValue()));
        }
        catch (NoSuchProviderException | CertificateException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            return null;
        }
    }

    protected void setCertificateEntry(String alias, Certificate cert, String groupId) throws KeyStoreException {
        LOGGER.debug("Add certificate for alias " + alias + " in keystore");
        SdkmsCertificateService.importCertificate(cert, alias, groupId);
    }
}

