/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.constants.AccessControlKeys;
import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.util.SdkmsShutDownHook;
import com.fortanix.sdkms.jce.provider.valentino.DSMAcceleratorClientSetup;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.Provider;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.LoggerFactory;

public class SdkmsJCE
extends Provider {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsJCE.class));
    private static final long serialVersionUID = 1L;
    private static volatile SdkmsJCE instance = null;
    private String serverVersion = "unknown";

    public SdkmsJCE() {
        super(Configuration.getInstance().getProviderName(), Configuration.getInstance().getProviderVersion(), Configuration.getInstance().getProviderInfo());
        LOGGER.debug("Setting up SDKMS API Client");
        try {
            if (Configuration.getInstance().isDSMAccelerator()) {
                DSMAcceleratorClientSetup.initialize().makeLoginRequest();
                this.serverVersion = DSMAcceleratorClientSetup.getInstance().getServerVersion();
            } else {
                ApiClientSetup.initialize().makeLoginRequest();
                this.serverVersion = ApiClientSetup.getInstance().getServerVersion();
            }
            AccessController.doPrivileged(() -> {
                Arrays.stream(AccessControlKeys.values()).forEach((? super T accessKey) -> this.put(accessKey.key(), accessKey.vaule()));
                if (Configuration.getInstance().isAesEcbDisabled()) {
                    LOGGER.debug("Disabling SDKMS AES_128/ECB/PKCS5Padding cipher support");
                    this.remove("Cipher.AES");
                    this.remove("Cipher.AES_128/ECB/PKCS5PADDING");
                }
                return null;
            });
            if (instance == null) {
                instance = this;
            }
            Runtime.getRuntime().addShutdownHook(new SdkmsShutDownHook());
        }
        catch (Exception e) {
            LOGGER.logAndRaiseProviderException("SDKMS Setup failed. ", e);
        }
        this.registerMBean();
        Runtime.getRuntime().addShutdownHook(new SdkmsShutDownHook());
    }

    private void registerMBean() {
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.fortanix.sdkms.jce.provider:name=SdkmsJCEStats");
            if (!platformMBeanServer.isRegistered(objectName)) {
                SdkmsJceStats jceMBean = new SdkmsJceStats();
                platformMBeanServer.registerMBean(jceMBean, objectName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register to MBean server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SdkmsJCE getInstance() {
        if (instance != null) return instance;
        Class<SdkmsJCE> clazz = SdkmsJCE.class;
        synchronized (SdkmsJCE.class) {
            if (instance != null) return instance;
            LOGGER.debug("Creating new instance of SdkmsJCE provider");
            instance = new SdkmsJCE();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static SdkmsJCE initialize(String apiEndpoint, String apiKey) {
        Configuration.initialize(apiKey, apiEndpoint);
        LOGGER.debug("Creating new instance of SdkmsJCE provider");
        instance = new SdkmsJCE();
        return instance;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    static {
        if (Configuration.getInstance().getLogLocation() != null) {
            LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
            try {
                logContext.setConfigLocation(SdkmsJCE.class.getResource("/log4j2-rolling.properties").toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Configuration.getInstance().isAPILogging()) {
            Configurator.setLevel((String)"SDKMS-API", (Level)Level.INFO);
        }
        if (Configuration.getInstance().isDebugLogging()) {
            Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)Level.DEBUG);
        }
    }

    public static class SdkmsJceStats
    implements SdkmsJceStatsMBean {
        @Override
        public Integer getNumActiveAPIConnections() {
            return ApiClientSetup.getInstance().getApiClient().getConnectionStats().getLeased();
        }

        @Override
        public Integer getNumPendingAPIConnections() {
            return ApiClientSetup.getInstance().getApiClient().getConnectionStats().getPending();
        }

        @Override
        public Integer getNumAvailableAPIConnections() {
            return ApiClientSetup.getInstance().getApiClient().getConnectionStats().getAvailable();
        }

        @Override
        public Integer getNumMaxAPIConnections() {
            return ApiClientSetup.getInstance().getApiClient().getConnectionStats().getMax();
        }
    }

    public static interface SdkmsJceStatsMBean {
        public Integer getNumActiveAPIConnections();

        public Integer getNumPendingAPIConnections();

        public Integer getNumAvailableAPIConnections();

        public Integer getNumMaxAPIConnections();
    }
}

