/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.KeyStore;
import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.constants.ProviderConstants;
import com.fortanix.sdkms.jce.provider.keys.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCertificateService;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.spec.SecurityObjectKeySpec;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.ObjectType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;

public final class SdkmsKeyStore
extends KeyStore {
    private static final String CERT_CHAIN_METADATA_PREFIX = "certificate";
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsKeyStore.class));
    private String groupId;

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        LOGGER.debug("Loading keystore");
        if (password != null) {
            this.setGroupId(password);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        LOGGER.debug("Saving keystore. No keys are stored in keystore file");
        this.setGroupId(password);
        if (this.groupId != null) {
            stream.write(this.groupId.getBytes());
        } else {
            stream.write("no-local-data".getBytes());
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        LOGGER.debug("Get all aliases for keystore");
        List<String> alias = this.getAllAlias();
        return Collections.enumeration(alias);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOGGER.debug("Get certificate chain for alias" + alias + " in keystore");
        KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(alias);
        if (keyObject == null) {
            LOGGER.logAndRaiseProviderException("Invalid alias received in the request. Cannot retrieve alias : " + alias + "  from sdkms", null);
        }
        if (keyObject.getCustomMetadata() == null) {
            return new Certificate[0];
        }
        ArrayList metadataKeys = new ArrayList(keyObject.getCustomMetadata().keySet());
        Collections.sort(metadataKeys);
        ArrayList chain = new ArrayList();
        metadataKeys.stream().filter(metadataKey -> metadataKey.startsWith(CERT_CHAIN_METADATA_PREFIX)).forEach(metadataKey -> {
            try {
                KeyObject certObject = SdkmsKeyService.getSecurityObjectByName((String)keyObject.getCustomMetadata().get(metadataKey));
                if (certObject != null) {
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "SUN");
                    chain.add(certFactory.generateCertificate(new ByteArrayInputStream(SdkmsKeyService.getKeyValue(certObject.getKid()))));
                }
            }
            catch (NoSuchProviderException | CertificateException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        });
        Certificate[] chainArray = new Certificate[chain.size()];
        return chain.toArray(chainArray);
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOGGER.debug("Get creation date for alias" + alias + " in keystore");
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(alias);
            return format.parse(keyObject.getCreatedAt());
        }
        catch (ParseException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Key engineGetKey(String name, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        LOGGER.debug("Get key for alias" + name + " in keystore");
        this.setGroupId(password);
        try {
            KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(name);
            return SdkmsKeyService.getKeyFromKeyObject(keyObject, false);
        }
        catch (InvalidKeyException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        LOGGER.debug("Add key for alias" + alias + " in keystore");
        this.setGroupId(password);
        KeyObject keyObject = null;
        if (!(key instanceof SdkmsKey)) {
            this.importKey(key, chain, alias);
        } else {
            HashMap<String, String> customMetadata = null;
            if (chain != null) {
                customMetadata = new HashMap<String, String>();
                for (int i = 0; i < chain.length; ++i) {
                    KeyObject certificateEntry = SdkmsCertificateService.importCertificate(chain[i], alias + "-certificate-" + i, this.groupId);
                    customMetadata.put(CERT_CHAIN_METADATA_PREFIX + i, certificateEntry.getName());
                }
            }
            if (((SdkmsKey)((Object)key)).getKeyDescriptor().getTransientKey() != null) {
                SdkmsKeyService.persistKey(key, alias, customMetadata);
            } else {
                keyObject = SdkmsKeyService.getKeyObject(((SdkmsKey)((Object)key)).getKeyDescriptor());
                if (this.groupId != null && !this.groupId.isEmpty() && !keyObject.getGroupId().equalsIgnoreCase(this.groupId)) {
                    LOGGER.logAndRaiseProviderException("GroupId for key and GroupId provided in password does not match", null);
                }
                SdkmsKeyService.updateKey(SdkmsKeyService.getKeyDescriptor(keyObject), alias, customMetadata);
            }
        }
    }

    private void importKey(Key key, Certificate[] chain, String alias) {
        LOGGER.debug("Importing key into SDKMS");
        if (key instanceof PrivateKey) {
            try {
                KeyFactory factory = KeyFactory.getInstance(key.getAlgorithm(), Configuration.getInstance().getProviderName());
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(key.getEncoded());
                SecurityObjectKeySpec keySpec = new SecurityObjectKeySpec((KeySpec)privKeySpec, this.groupId, alias);
                factory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        } else {
            try {
                SecretKeyFactory factory = SecretKeyFactory.getInstance(key.getAlgorithm(), Configuration.getInstance().getProviderName());
                SecretKeySpec secretKeySpec = new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
                SecurityObjectKeySpec keySpec = new SecurityObjectKeySpec((KeySpec)secretKeySpec, this.groupId, alias);
                factory.generateSecret(keySpec);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LOGGER.debug("Deleting entry" + alias + " from keystore");
        KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(alias);
        if (keyObject == null) {
            LOGGER.logAndRaiseProviderException("No entry present for alias : " + alias + "  in sdkms", null);
        }
        if (keyObject.getCustomMetadata() != null) {
            ArrayList certificateEntry = new ArrayList(keyObject.getCustomMetadata().values());
            int failureCount = 0;
            for (int i = 0; i < certificateEntry.size(); ++i) {
                KeyObject certificateKeyObject = SdkmsKeyService.getSecurityObjectByName((String)certificateEntry.get(i));
                if (certificateKeyObject == null) continue;
                try {
                    SdkmsKeyService.deleteKey(certificateKeyObject.getKid());
                    continue;
                }
                catch (Exception e) {
                    ++failureCount;
                    LOGGER.warn("Ignoring certificate deletion failure in SDKMS: " + (String)certificateEntry.get(i), e);
                }
            }
            if (failureCount > 0) {
                LOGGER.logAndRaiseProviderException("Certificate Chain deletion failed", null);
            }
        }
        SdkmsKeyService.deleteKey(keyObject.getKid());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        LOGGER.debug("Contains check for alias " + alias + " in keystore");
        return this.getAllAlias().contains(alias);
    }

    @Override
    public int engineSize() {
        LOGGER.debug("Get size of the keystore");
        return this.getAllAlias().size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        LOGGER.debug("Is key check for alias " + alias + " in keystore");
        KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(alias);
        if (keyObject == null) {
            return false;
        }
        return !keyObject.getObjType().equals(ObjectType.OPAQUE) && !keyObject.getObjType().equals(ObjectType.CERTIFICATE);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        LOGGER.debug("Is certificate check for alias " + alias + " in keystore");
        KeyObject keyObject = SdkmsKeyService.getSecurityObjectByName(alias);
        if (keyObject == null) {
            return false;
        }
        return keyObject.getObjType().equals(ObjectType.OPAQUE) || keyObject.getObjType().equals(ObjectType.CERTIFICATE);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        LOGGER.debug("Get alias for certificate in keystore. This just returns null.");
        return null;
    }

    private List<String> getAllAlias() {
        List<KeyObject> keys = SdkmsKeyService.getKeys(null, this.groupId, null);
        ArrayList<String> alias = new ArrayList<String>();
        for (KeyObject key : keys) {
            alias.add(key.getName());
        }
        return alias;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        LOGGER.debug("Add certificate with alias " + alias + " to keystore");
        try {
            super.setCertificateEntry(alias, cert, this.groupId);
        }
        catch (KeyStoreException e) {
            LOGGER.logAndRaiseProviderException("Failed to set certificate in keystore", e);
        }
    }

    private void setGroupId(char[] password) {
        if (password != null) {
            this.groupId = String.valueOf(password);
            if (!ProviderConstants.VALID_GROUPID_LENGTH.contains(this.groupId.length())) {
                this.groupId = null;
            }
        }
    }
}

