/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.ciphers;

import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.EncryptionAndDecryptionApi;
import com.fortanix.sdkms.v1.api.WrappingAndUnwrappingApi;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.DecryptFinalRequestEx;
import com.fortanix.sdkms.v1.model.DecryptFinalResponse;
import com.fortanix.sdkms.v1.model.DecryptInitRequestEx;
import com.fortanix.sdkms.v1.model.DecryptInitResponse;
import com.fortanix.sdkms.v1.model.DecryptRequestEx;
import com.fortanix.sdkms.v1.model.DecryptResponse;
import com.fortanix.sdkms.v1.model.DecryptUpdateRequestEx;
import com.fortanix.sdkms.v1.model.DecryptUpdateResponse;
import com.fortanix.sdkms.v1.model.EncryptFinalRequestEx;
import com.fortanix.sdkms.v1.model.EncryptFinalResponse;
import com.fortanix.sdkms.v1.model.EncryptInitRequestEx;
import com.fortanix.sdkms.v1.model.EncryptInitResponse;
import com.fortanix.sdkms.v1.model.EncryptRequestEx;
import com.fortanix.sdkms.v1.model.EncryptResponse;
import com.fortanix.sdkms.v1.model.EncryptUpdateRequestEx;
import com.fortanix.sdkms.v1.model.EncryptUpdateResponse;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.UnwrapKeyRequestEx;
import com.fortanix.sdkms.v1.model.WrapKeyRequestEx;
import com.fortanix.sdkms.v1.model.WrapKeyResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public class SdkmsCipher {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsCipher.class));
    private static final List<Integer> validGcmTagLength = Arrays.asList(128, 120, 112, 104, 96, 64, 32);

    public static void attachGCMTag(ByteArrayOutputStream cipherStream, CryptMode mode, byte[] gcmTag, int expectedTagLength) throws IOException {
        if (!SdkmsCipher.isGCM(mode)) {
            return;
        }
        if (gcmTag == null) {
            LOGGER.logAndRaiseProviderException(String.format("%s tag is missing", mode), null);
        }
        if (gcmTag.length * 8 != expectedTagLength) {
            LOGGER.logAndRaiseProviderException(String.format("SDKMS generated tag length doesn't matched, Expected: %s, Actual: %s", expectedTagLength, gcmTag.length), null);
        }
        cipherStream.write(gcmTag);
    }

    public static byte[] encrypt(final EncryptRequestEx encryptRequest) {
        ByteArrayOutputStream cipherStream = new ByteArrayOutputStream();
        byte[] cipherBytes = null;
        try {
            Integer expectedTagLength = encryptRequest.getTagLen();
            EncryptResponse encryptResponse = (EncryptResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).encryptEx(encryptRequest);
                }

                @Override
                public String getDescription() {
                    return "Encrypt";
                }
            });
            cipherStream.write(encryptResponse.getCipher());
            if (SdkmsCipher.isGCM(encryptRequest.getMode())) {
                SdkmsCipher.attachGCMTag(cipherStream, encryptRequest.getMode(), encryptResponse.getTag(), expectedTagLength);
            }
            cipherBytes = cipherStream.toByteArray();
        }
        catch (ApiException | IOException exception) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encryption. Selected mode was " + encryptRequest.getMode(), exception);
        }
        return cipherBytes;
    }

    public static EncryptInitResponse encryptInit(final EncryptInitRequestEx initRequest) {
        EncryptInitResponse encryptResponse = null;
        try {
            encryptResponse = (EncryptInitResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).encryptInitEx(initRequest);
                }

                @Override
                public String getDescription() {
                    return "EncryptInit";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher Init. Selected mode was " + initRequest.getMode(), apiException);
        }
        return encryptResponse;
    }

    public static EncryptUpdateResponse encryptUpdate(final EncryptUpdateRequestEx updateRequest) {
        EncryptUpdateResponse encryptUpdate = null;
        try {
            encryptUpdate = (EncryptUpdateResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).encryptUpdateEx(updateRequest);
                }

                @Override
                public String getDescription() {
                    return "EncryptUpdate";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encrypt update", apiException);
        }
        return encryptUpdate;
    }

    public static byte[] encryptFinal(final EncryptFinalRequestEx encryptRequest, CryptMode mode) {
        ByteArrayOutputStream cipherStream = new ByteArrayOutputStream();
        byte[] cipherBytes = null;
        try {
            Integer expectedTagLength = encryptRequest.getTagLen();
            EncryptFinalResponse encryptResponse = (EncryptFinalResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).encryptFinalEx(encryptRequest);
                }

                @Override
                public String getDescription() {
                    return "EncryptFinal";
                }
            });
            cipherStream.write(encryptResponse.getCipher());
            if (SdkmsCipher.isGCM(mode)) {
                SdkmsCipher.attachGCMTag(cipherStream, mode, encryptResponse.getTag(), expectedTagLength);
            }
            cipherBytes = cipherStream.toByteArray();
        }
        catch (ApiException | IOException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encryption. Selected mode was " + mode, apiException);
        }
        return cipherBytes;
    }

    public static byte[] decrypt(Integer tagLength, final DecryptRequestEx decryptRequest) {
        DecryptResponse decryptRes = null;
        try {
            if (SdkmsCipher.isGCM(decryptRequest.getMode())) {
                CipherAndTag cipherAndTag = SdkmsCipher.extractGCMTag(tagLength, decryptRequest.getCipher(), 0, decryptRequest.getCipher().length);
                decryptRequest.setCipher(cipherAndTag.cipher);
                decryptRequest.setTag(cipherAndTag.tag);
            }
            decryptRes = (DecryptResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).decryptEx(decryptRequest);
                }

                @Override
                public String getDescription() {
                    return "Decrypt";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encryption. Selected mode was " + decryptRequest.getMode(), apiException);
        }
        return decryptRes.getPlain();
    }

    public static DecryptInitResponse decryptInit(final DecryptInitRequestEx initRequest) {
        DecryptInitResponse decryptResponse = null;
        try {
            decryptResponse = (DecryptInitResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).decryptInitEx(initRequest);
                }

                @Override
                public String getDescription() {
                    return "DecryptInit";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher Decrypt Init. Selected mode was " + initRequest.getMode(), apiException);
        }
        return decryptResponse;
    }

    public static DecryptUpdateResponse decryptUpdate(final DecryptUpdateRequestEx updateRequest) {
        DecryptUpdateResponse decryptUpdate = null;
        try {
            decryptUpdate = (DecryptUpdateResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).decryptUpdateEx(updateRequest);
                }

                @Override
                public String getDescription() {
                    return "DecryptUpdate";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encrypt update", apiException);
        }
        return decryptUpdate;
    }

    public static byte[] decryptFinal(final DecryptFinalRequestEx decryptRequest) {
        DecryptFinalResponse decryptRes = null;
        try {
            decryptRes = (DecryptFinalResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new EncryptionAndDecryptionApi(ApiClientSetup.getInstance().getApiClient()).decryptFinalEx(decryptRequest);
                }

                @Override
                public String getDescription() {
                    return "DecryptFinal";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encryption. ", apiException);
        }
        return decryptRes.getPlain();
    }

    public static byte[] wrapKey(final WrapKeyRequestEx wrapKeyRequest) {
        ByteArrayOutputStream cipherStream = new ByteArrayOutputStream();
        Integer expectedTagLength = wrapKeyRequest.getTagLen();
        try {
            WrapKeyResponse wrapResponse = (WrapKeyResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new WrappingAndUnwrappingApi(ApiClientSetup.getInstance().getApiClient()).wrapKeyEx(wrapKeyRequest);
                }

                @Override
                public String getDescription() {
                    return "WrapKey";
                }
            });
            cipherStream.write(wrapResponse.getWrappedKey());
            if (SdkmsCipher.isGCM(wrapKeyRequest.getMode())) {
                SdkmsCipher.attachGCMTag(cipherStream, wrapKeyRequest.getMode(), wrapResponse.getTag(), expectedTagLength);
            }
        }
        catch (ApiException | IOException e) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encryption. Selected mode was " + wrapKeyRequest.getMode(), e);
        }
        return cipherStream.toByteArray();
    }

    public static KeyObject unwrapKey(Integer tagLength, final UnwrapKeyRequestEx unwrapKeyRequest) {
        KeyObject keyObject = null;
        try {
            if (SdkmsCipher.isGCM(unwrapKeyRequest.getMode())) {
                CipherAndTag cipherAndTag = SdkmsCipher.extractGCMTag(tagLength, unwrapKeyRequest.getWrappedKey(), 0, unwrapKeyRequest.getWrappedKey().length);
                unwrapKeyRequest.setWrappedKey(cipherAndTag.cipher);
                unwrapKeyRequest.setTag(cipherAndTag.tag);
            }
            keyObject = (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new WrappingAndUnwrappingApi(ApiClientSetup.getInstance().getApiClient()).unwrapKeyEx(unwrapKeyRequest);
                }

                @Override
                public String getDescription() {
                    return "UnwrapKey";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Cipher encryption. Selected mode was " + unwrapKeyRequest.getMode(), apiException);
        }
        return keyObject;
    }

    public static boolean isGCM(CryptMode mode) {
        return mode == CryptMode.GCM || mode == CryptMode.CCM;
    }

    public static boolean isGCM(String mode) {
        return SdkmsCipher.isGCM(CryptMode.fromValue((String)mode));
    }

    public static boolean isValidTagLength(Integer tagLength) {
        return validGcmTagLength.contains(tagLength);
    }

    public static String supportedGcmTagLength() {
        return validGcmTagLength.toString();
    }

    public static CipherAndTag extractGCMTag(int tagLength, byte[] cipherTagBytes, int cipherTagOffset, int cipherTagLen) {
        CipherAndTag cipherAndTag = new CipherAndTag();
        if (cipherTagBytes == null || cipherTagBytes.length == 0 || cipherTagLen == 0) {
            return cipherAndTag;
        }
        int tagLengthInByte = tagLength / 8;
        int cipherLengthInByte = cipherTagLen - tagLengthInByte;
        cipherAndTag.tag = new byte[tagLengthInByte];
        cipherAndTag.cipher = new byte[cipherLengthInByte];
        cipherAndTag.cipherOffset = 0;
        cipherAndTag.cipherLen = cipherLengthInByte;
        System.arraycopy(cipherTagBytes, cipherTagOffset + cipherLengthInByte, cipherAndTag.tag, 0, tagLengthInByte);
        System.arraycopy(cipherTagBytes, cipherTagOffset, cipherAndTag.cipher, 0, cipherLengthInByte);
        return cipherAndTag;
    }

    public static class CipherAndTag {
        public byte[] cipher;
        public int cipherOffset;
        public int cipherLen;
        public byte[] tag;

        public CipherAndTag() {
        }

        public CipherAndTag(byte[] cipher, int cipherOffset, int cipherLen, byte[] tag) {
            this.cipher = cipher;
            this.cipherOffset = cipherOffset;
            this.cipherLen = cipherLen;
            this.tag = tag;
        }
    }
}

