/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.constants;

import com.fortanix.sdkms.v1.model.DigestAlgorithm;

public enum DigestAlgorithms {
    SHA1("SHA1", DigestAlgorithm.SHA1),
    SHA256("SHA-256", DigestAlgorithm.SHA256),
    SHA384("SHA-384", DigestAlgorithm.SHA384),
    SHA512("SHA-512", DigestAlgorithm.SHA512),
    STREEBOG256("Streebog-256", DigestAlgorithm.STREEBOG256),
    STREEBOG512("Streebog-512", DigestAlgorithm.STREEBOG512);

    private final String key;
    private final DigestAlgorithm value;

    private DigestAlgorithms(String key, DigestAlgorithm value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public DigestAlgorithm getValue() {
        return this.value;
    }

    public static DigestAlgorithms getByKey(String key) {
        for (DigestAlgorithms current : DigestAlgorithms.values()) {
            if (!current.key.equalsIgnoreCase(key)) continue;
            return current;
        }
        return null;
    }
}

