/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.constants;

import com.fortanix.sdkms.v1.model.EllipticCurve;

public enum ECGenSpec {
    SecP192K1("secp192k1", EllipticCurve.SECP192K1),
    SecP224K1("secp224k1", EllipticCurve.SECP224K1),
    SecP256K1("secp256k1", EllipticCurve.SECP256K1),
    NistP192("NIST P-192", EllipticCurve.NISTP192),
    NistP224("NIST P-224", EllipticCurve.NISTP224),
    NistP256("NIST P-256", EllipticCurve.NISTP256),
    NistP384("NIST P-384", EllipticCurve.NISTP384),
    NistP521("NIST P-521", EllipticCurve.NISTP521),
    Secp192r1("secp192r1", EllipticCurve.NISTP192),
    Secp224r1("secp224r1", EllipticCurve.NISTP224),
    Secp256r1("secp256r1", EllipticCurve.NISTP256),
    Secp384r1("secp384r1", EllipticCurve.NISTP384),
    Secp521r1("secp521r1", EllipticCurve.NISTP521),
    Gost256a("GOST 256A", EllipticCurve.GOST256A),
    Ed25519("Ed25519", EllipticCurve.ED25519),
    X25519("X25519", EllipticCurve.X25519),
    X448("X448", EllipticCurve.X448);

    private final String key;
    private final EllipticCurve value;

    private ECGenSpec(String key, EllipticCurve value) {
        this.value = value;
        this.key = key;
    }

    public EllipticCurve getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public static ECGenSpec getByKey(String key) {
        for (ECGenSpec current : ECGenSpec.values()) {
            if (!current.key.equalsIgnoreCase(key)) continue;
            return current;
        }
        return null;
    }
}

