/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.constants;

import com.fortanix.sdkms.v1.model.EllipticCurve;

public enum ECKeySizeSpec {
    SecP192K1(EllipticCurve.SECP192K1, 192),
    SecP224K1(EllipticCurve.SECP224K1, 224),
    SecP256K1(EllipticCurve.SECP256K1, 256),
    NistP192(EllipticCurve.NISTP192, 192),
    NistP224(EllipticCurve.NISTP224, 224),
    NistP256(EllipticCurve.NISTP256, 256),
    NistP384(EllipticCurve.NISTP384, 384),
    NistP521(EllipticCurve.NISTP521, 521),
    Secp192r1(EllipticCurve.SECP192K1, 192),
    Secp224r1(EllipticCurve.SECP224K1, 224),
    Secp256r1(EllipticCurve.SECP256K1, 256);

    private final EllipticCurve key;
    private final int value;

    private ECKeySizeSpec(EllipticCurve key, int value) {
        this.value = value;
        this.key = key;
    }

    public int getValue() {
        return this.value;
    }

    public EllipticCurve getKey() {
        return this.key;
    }

    public static ECKeySizeSpec getByKey(String key) {
        for (ECKeySizeSpec current : ECKeySizeSpec.values()) {
            if (!current.key.toString().equalsIgnoreCase(key)) continue;
            return current;
        }
        return null;
    }
}

