/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.digests;

import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.digests.SdkmsDigest;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.DigestResponse;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import org.slf4j.LoggerFactory;

public abstract class MessageDigestImpl
extends MessageDigestSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(MessageDigestImpl.class));
    private DigestAlgorithm algorithm;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean supportsSunImplementation;

    protected MessageDigestImpl(DigestAlgorithm algorithm, boolean supportsSunImplementation) {
        this.algorithm = algorithm;
        this.supportsSunImplementation = supportsSunImplementation;
        this.engineReset();
    }

    @Override
    public void engineUpdate(byte b) {
        LOGGER.debug("MessageDigest: update");
        this.dataStream.write(b);
    }

    @Override
    public void engineUpdate(byte[] b, int offset, int length) {
        LOGGER.debug("MessageDigest: update");
        this.dataStream.write(b, offset, length);
    }

    @Override
    public void engineReset() {
        LOGGER.debug("MessageDigest: reset");
        this.dataStream.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] engineDigest() {
        LOGGER.debug("MessageDigest: compute digest");
        if (this.supportsSunImplementation && Configuration.getInstance().getLocalDigestEnabledFlag()) {
            try {
                String sunAlg = ProviderUtil.getSunAlgoForMessageDigest(this.algorithm);
                byte[] byArray = MessageDigest.getInstance(sunAlg, "SUN").digest(this.dataStream.toByteArray());
                return byArray;
            }
            catch (Exception exception) {
                LOGGER.logAndRaiseProviderException("Error computing message Digest for algorithm : " + this.algorithm, exception);
            }
            finally {
                this.engineReset();
            }
        }
        try {
            DigestResponse digestResponse = SdkmsDigest.computeDigest(this.algorithm, this.dataStream.toByteArray());
            byte[] byArray = digestResponse.getDigest();
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    public static final class Streebog512MessageDigest
    extends MessageDigestImpl {
        public Streebog512MessageDigest() {
            super(DigestAlgorithm.STREEBOG512, false);
            LOGGER.debug("MessageDigest: being initialized for Streebog-512");
        }
    }

    public static final class Streebog256MessageDigest
    extends MessageDigestImpl {
        public Streebog256MessageDigest() {
            super(DigestAlgorithm.STREEBOG256, false);
            LOGGER.debug("MessageDigest: being initialized for Streebog-256");
        }
    }

    public static final class SHA512MessageDigest
    extends MessageDigestImpl {
        public SHA512MessageDigest() {
            super(DigestAlgorithm.SHA512, true);
            LOGGER.debug("MessageDigest: being initialized for SHA-512");
        }
    }

    public static final class SHA384MessageDigest
    extends MessageDigestImpl {
        public SHA384MessageDigest() {
            super(DigestAlgorithm.SHA384, true);
            LOGGER.debug("MessageDigest: being initialized for SHA-384");
        }
    }

    public static final class SHA256MessageDigest
    extends MessageDigestImpl {
        public SHA256MessageDigest() {
            super(DigestAlgorithm.SHA256, true);
            LOGGER.debug("MessageDigest: being initialized for SHA-256");
        }
    }

    public static final class SHA1MessageDigest
    extends MessageDigestImpl {
        public SHA1MessageDigest() {
            super(DigestAlgorithm.SHA1, true);
            LOGGER.debug("MessageDigest: being initialized for SHA1");
        }
    }
}

