/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.digests;

import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.DigestApi;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.DigestRequest;
import com.fortanix.sdkms.v1.model.DigestResponse;
import org.slf4j.LoggerFactory;

public class SdkmsDigest {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsDigest.class));

    public static DigestResponse computeDigest(DigestAlgorithm alg, byte[] data) {
        DigestResponse digestResponse = null;
        try {
            final DigestRequest digestRequest = new DigestRequest();
            digestRequest.setAlg(alg);
            digestRequest.setData(data);
            digestResponse = (DigestResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new DigestApi(ApiClientSetup.getInstance().getApiClient()).computeDigest(digestRequest);
                }

                @Override
                public String getDescription() {
                    return "Digest";
                }
            });
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to compute message Digest for algorithm : " + alg, apiException);
        }
        return digestResponse;
    }
}

