/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.dsa;

import com.fortanix.sdkms.jce.provider.keys.asym.dsa.DSAPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.dsa.DSAPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.dsa.SdkmsDsa;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.spec.SecurityObjectParameterSpec;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAGenParameterSpec;
import java.util.List;
import org.slf4j.LoggerFactory;

public class DSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DSAKeyPairGenerator.class));
    private int keySize;
    private String groupId;
    private int subgroupSize;
    private List<KeyOperations> allowedKeyOperation;
    private boolean isTransientKey = true;

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        LOGGER.debug("DSAKeyPairGenerator: init using params");
        if (params instanceof SecurityObjectParameterSpec) {
            this.allowedKeyOperation = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
            this.groupId = ((SecurityObjectParameterSpec)params).getGroupId();
            this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
            params = ((SecurityObjectParameterSpec)params).getParamSpec();
        }
        if (params == null) {
            return;
        }
        if (params instanceof DSAGenParameterSpec) {
            this.keySize = ((DSAGenParameterSpec)params).getPrimePLength();
            this.subgroupSize = ((DSAGenParameterSpec)params).getSubprimeQLength();
            return;
        }
        throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec or SecurityObjectParameterSpec");
    }

    @Override
    public void initialize(int keySize, SecureRandom secureRandom) {
        LOGGER.debug("DSAKeyPairGenerator: init using keysize " + keySize);
        if (keySize != 2048 && keySize != 3072) {
            LOGGER.logAndRaiseProviderException("Invalid key size: " + keySize, null);
        }
        this.keySize = keySize;
    }

    @Override
    public KeyPair generateKeyPair() {
        LOGGER.debug("RSAKeyPairGenerator: generate");
        KeyObject keyObject = SdkmsDsa.generateKeyForDsaOperation(this.keySize, this.allowedKeyOperation, this.groupId, this.isTransientKey, this.subgroupSize);
        DSAPublicKeyImpl rsaPublicKey = new DSAPublicKeyImpl(keyObject);
        DSAPrivateKeyImpl rsaPrivateKey = new DSAPrivateKeyImpl(keyObject);
        return new KeyPair(rsaPublicKey, rsaPrivateKey);
    }
}

