/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.dsa;

import com.fortanix.sdkms.jce.provider.keys.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.slf4j.LoggerFactory;
import sun.security.util.DerInputStream;
import sun.security.x509.X509Key;

public class DSAPublicKeyImpl
extends X509Key
implements DSAPublicKey,
SdkmsKey {
    private SobjectDescriptor keyDescriptor;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DSAPublicKeyImpl.class));
    private BigInteger y;

    public DSAPublicKeyImpl(KeyObject keyObject) {
        this.keyDescriptor = SdkmsKeyService.getKeyDescriptor(keyObject);
        this.initFromKeyObject(keyObject);
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.keyDescriptor.setTransientKey(keyObject.getTransientKey());
        this.keyDescriptor.setKid(keyObject.getKid());
        this.keyDescriptor.setName(null);
        try {
            this.decode(keyObject.getPubKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.logAndRaiseProviderException("Unable to decode DSA public key", invalidKeyException);
        }
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters var2 = this.algid.getParameters();
            if (var2 == null) {
                return null;
            }
            DSAParameterSpec var1 = var2.getParameterSpec(DSAParameterSpec.class);
            return var1;
        }
        catch (InvalidParameterSpecException var3) {
            return null;
        }
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream var1 = new DerInputStream(this.getKey().toByteArray());
            this.y = var1.getBigInteger();
        }
        catch (IOException var2) {
            throw new InvalidKeyException("Invalid DSA public key: y value\n" + var2.getMessage());
        }
    }
}

