/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.dsa;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.DsaOptions;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import org.slf4j.LoggerFactory;

public class SdkmsDsa {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsDsa.class));

    public static KeyObject generateKeyForDsaOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, String groupId, boolean isTransientKey, Integer subgroupSize) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, isTransientKey, "DSA");
            if (groupId != null) {
                sObjReq.setGroupId(groupId);
            }
            DsaOptions dsa = new DsaOptions();
            if (subgroupSize != null) {
                dsa.setSubgroupSize(subgroupSize);
                sObjReq.setDsa(dsa);
            }
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "DSA");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during DSA Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

