/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.elliptic;

import com.fortanix.sdkms.jce.provider.keys.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.LoggerFactory;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class ECPrivateKeyImpl
implements ECPrivateKey,
SdkmsKey {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(ECPrivateKey.class));
    private static final long serialVersionUID = 7009840881519984915L;
    private ECParameterSpec params;
    private SobjectDescriptor descriptor;
    private Boolean isExportable;
    private byte[] encoded;

    public ECPrivateKeyImpl(SobjectDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ECPrivateKeyImpl(KeyObject keyObject) {
        this(SdkmsKeyService.getKeyDescriptor(keyObject));
        this.initFromKeyObject(keyObject);
    }

    @Deprecated
    public ECPrivateKeyImpl(String keyId, ECParameterSpec params, String transientKey) {
        this(new SobjectDescriptor().kid(keyId).transientKey(transientKey));
        this.params = params;
    }

    public ECPrivateKeyImpl params(ECParameterSpec params) {
        this.params = params;
        return this;
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.isExportable = keyObject.getKeyOps() != null && keyObject.getKeyOps().contains(KeyOperations.EXPORT);
        this.descriptor.setTransientKey(keyObject.getTransientKey());
        this.descriptor.setKid(keyObject.getKid());
        this.descriptor.setName(null);
        try {
            this.params(SdkmsKeyService.getECPrivateKeyParams(keyObject));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException("Unable to extract key params for EC private key.", e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    public String getFormat() {
        return "raw";
    }

    @Override
    public byte[] getEncoded() {
        if (this.isExportable == null) {
            KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
            this.initFromKeyObject(keyObject);
        }
        if (this.isExportable.booleanValue()) {
            if (this.encoded == null) {
                this.encoded = SdkmsKeyService.getKeyValue(this.descriptor);
            }
        } else {
            LOGGER.info("Trying to get key material of a non exportable key: " + ProviderUtil.toStringSobjectDescriptor(this.descriptor));
        }
        return this.encoded;
    }

    @Override
    public BigInteger getS() {
        try {
            DerInputStream der = new DerInputStream(this.getEncoded());
            DerValue[] data = der.getSequence(0);
            int ver = data[0].getInteger();
            if (ver == 1) {
                return new BigInteger(data[1].getOctetString());
            }
            if (ver == 0) {
                return new BigInteger(data[2].getOctetString());
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }
}

