/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.elliptic;

import com.fortanix.sdkms.jce.provider.keys.SdkmsKey;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class ECPublicKeyImpl
implements ECPublicKey,
SdkmsKey {
    private static final long serialVersionUID = 8589404489186396796L;
    private SobjectDescriptor descriptor;
    private byte[] encoded;
    private ECParameterSpec params;

    public ECPublicKeyImpl(SobjectDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ECPublicKeyImpl(KeyObject keyObject) {
        this.descriptor = SdkmsKeyService.getKeyDescriptor(keyObject);
        this.encodedMaterial((byte[])keyObject.getPubKey().clone());
    }

    @Deprecated
    public ECPublicKeyImpl(String keyId, byte[] encoded, String transientKey) {
        this(new SobjectDescriptor().kid(keyId).transientKey(transientKey));
        this.encodedMaterial(encoded);
    }

    public ECPublicKeyImpl params(ECParameterSpec params) {
        this.params = params;
        return this;
    }

    public ECPublicKeyImpl encodedMaterial(byte[] encoded) {
        this.encoded = encoded;
        return this;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public ECPoint getW() {
        try {
            DerInputStream der = new DerInputStream(this.encoded);
            DerValue[] data = der.getSequence(0);
            byte[] bits = data[1].getData().toByteArray();
            if (bits[0] != 0 && bits[1] != 4) {
                return null;
            }
            int field_size = (bits.length - 2) / 2;
            byte[] xb = Arrays.copyOfRange(bits, 2, 2 + field_size);
            byte[] yb = Arrays.copyOfRange(bits, 2 + field_size, 2 + 2 * field_size);
            return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    public String getFormat() {
        return "raw";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }
}

