/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.elliptic;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.EllipticCurve;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import org.slf4j.LoggerFactory;

public class SdKmsEc {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdKmsEc.class));

    public static KeyObject generateKeyForEcOperation(EllipticCurve curve, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(null, allowedKeyOperations, isTransientKey, "EC");
            sObjReq.setEllipticCurve(curve);
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "EC");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to generate EC Key Pair for curve : " + curve, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForEcOperation(List<KeyOperations> allowedKeyOperations, byte[] keyMaterial, String alias) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(null, allowedKeyOperations, null, "EC");
            if (keyMaterial != null) {
                sObjReq.setValue(keyMaterial);
            }
            if (alias != null && !alias.isEmpty()) {
                sObjReq.setName(alias);
            }
            keyObject = SdkmsCommonService.importKeyForAlgorithm(sObjReq, "EC");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed to import EC Key Pair", apiException);
        }
        return keyObject;
    }
}

