/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.rsa;

import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.RSAPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.RSAPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.keys.asym.rsa.SdKmsRsa;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.spec.SecurityObjectKeySpec;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import org.slf4j.LoggerFactory;

public class RSAKeyFactory
extends KeyFactorySpi {
    private List<KeyOperations> allowedKeyOperations;
    private RsaEncryptionPolicy rsaEncryptionPolicy;
    private RsaSignaturePolicy rsaSignaturePolicy;
    private String groupId;
    private String alias;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSAKeyFactory.class));

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        LOGGER.debug("RSAKeyFactory: import public key using keyspec");
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            this.rsaEncryptionPolicy = ((SecurityObjectKeySpec)keySpec).getEncryptionPolicy();
            this.rsaSignaturePolicy = ((SecurityObjectKeySpec)keySpec).getSignaturePolicy();
            this.groupId = ((SecurityObjectKeySpec)keySpec).getGroupId();
            this.alias = ((SecurityObjectKeySpec)keySpec).getAlias();
            keySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        if (Configuration.getInstance().getTransientPubkeyImportOnlyFlag()) {
            try {
                return KeyFactory.getInstance("RSA", "SunJSSE").generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        }
        byte[] encoded = null;
        if (keySpec instanceof X509EncodedKeySpec) {
            encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
        } else if (keySpec instanceof RSAPublicKeySpec) {
            try {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)KeyFactory.getInstance("RSA", "SunJSSE").generatePublic(keySpec);
                encoded = rsaPublicKey.getEncoded();
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        } else {
            LOGGER.logAndRaiseProviderException("Invalid Spec for generating Public Key. Only X509EncodedKeySpec and RSAPublicKeySpec are supported", null);
        }
        KeyObject keyObject = SdKmsRsa.importKeyForRsaOperation(this.allowedKeyOperations, encoded, this.rsaEncryptionPolicy, this.rsaSignaturePolicy, this.groupId, this.alias);
        return new RSAPublicKeyImpl(keyObject);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        LOGGER.debug("RSAKeyFactory: import private key using keyspec");
        if (!(keySpec instanceof PKCS8EncodedKeySpec) && !(keySpec instanceof SecurityObjectKeySpec)) {
            LOGGER.logAndRaiseProviderException("Invalid Spec for generating Public Key. Only PKCS8EncodedKeySpec and SecurityObjectKeySpec are supported", null);
        }
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            this.rsaEncryptionPolicy = ((SecurityObjectKeySpec)keySpec).getEncryptionPolicy();
            this.rsaSignaturePolicy = ((SecurityObjectKeySpec)keySpec).getSignaturePolicy();
            this.groupId = ((SecurityObjectKeySpec)keySpec).getGroupId();
            this.alias = ((SecurityObjectKeySpec)keySpec).getAlias();
            keySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        KeyObject keyObject = SdKmsRsa.importKeyForRsaOperation(this.allowedKeyOperations, ((PKCS8EncodedKeySpec)keySpec).getEncoded(), this.rsaEncryptionPolicy, this.rsaSignaturePolicy, this.groupId, this.alias);
        return new RSAPrivateKeyImpl(keyObject);
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        LOGGER.debug("RSAKeyFactory: get keyspec");
        if (key instanceof RSAPublicKey) {
            if (X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("KeySpec must be X509EncodedKeySpec for RSA public keys");
        }
        if (key instanceof RSAPrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(keySpec)) {
                return (T)((KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("KeySpec must be PKCS8EncodedKeySpec for RSA private keys");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        LOGGER.debug("RSAKeyFactory: translate key");
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!key.getAlgorithm().equals("RSA")) {
            throw new InvalidKeyException("Not an RSA key: " + key.getAlgorithm());
        }
        if (key instanceof PublicKey) {
            return this.translatePublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivateKey((PrivateKey)key);
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    private PublicKey translatePublicKey(PublicKey key) throws InvalidKeyException {
        if ("X.509".equals(key.getFormat())) {
            try {
                return this.engineGeneratePublic(this.engineGetKeySpec(key, X509EncodedKeySpec.class));
            }
            catch (InvalidKeySpecException e) {
                LOGGER.logAndRaiseProviderException("Failed to translate public key", e);
            }
        } else {
            throw new InvalidKeyException("Public keys must have X.509 encoding");
        }
        return null;
    }

    private PrivateKey translatePrivateKey(PrivateKey key) throws InvalidKeyException {
        if ("PKCS#8".equals(key.getFormat())) {
            try {
                return this.engineGeneratePrivate(this.engineGetKeySpec(key, PKCS8EncodedKeySpec.class));
            }
            catch (InvalidKeySpecException e) {
                LOGGER.logAndRaiseProviderException("Failed to translate private key", e);
            }
        } else {
            throw new InvalidKeyException("Private keys must have PKCS#8 encoding");
        }
        return null;
    }
}

