/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.rsa;

import com.fortanix.sdkms.jce.provider.keys.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.LoggerFactory;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class RSAPrivateKeyImpl
extends PKCS8Key
implements RSAPrivateKey,
SdkmsCipherKey,
RSAPrivateCrtKey {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSAPrivateKeyImpl.class));
    private SobjectDescriptor descriptor;
    private Integer keySize;
    private BigInteger modulus;
    private Boolean isExportable;
    private byte[] encoded;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    public RSAPrivateKeyImpl(SobjectDescriptor descriptor) {
        this.descriptor = descriptor;
        KeyObject keyObject = SdkmsKeyService.getKeyObject(descriptor);
        this.initFromKeyObject(keyObject);
    }

    public RSAPrivateKeyImpl(KeyObject keyObject) {
        this.descriptor = SdkmsKeyService.getKeyDescriptor(keyObject);
        this.initFromKeyObject(keyObject);
    }

    @Deprecated
    public RSAPrivateKeyImpl(String keyId, Integer keySize, BigInteger modulus, String transientKey) {
        this(new SobjectDescriptor().kid(keyId).transientKey(transientKey));
        this.keySize = keySize;
        this.modulus = modulus;
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.keySize = keyObject.getKeySize();
        this.isExportable = keyObject.getKeyOps() != null && keyObject.getKeyOps().contains(KeyOperations.EXPORT);
        this.descriptor.setTransientKey(keyObject.getTransientKey());
        this.descriptor.setKid(keyObject.getKid());
        this.descriptor.setName(null);
        try {
            RSAPublicKey pubKey = SdkmsKeyService.getRSAPublicKey(keyObject);
            this.modulus = pubKey.getModulus();
            this.publicExponent = pubKey.getPublicExponent();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException("Unable to extract modulus for RSA private key.", e);
        }
    }

    private void initPrivateKeyParamsIfExportable() {
        if (this.isExportable == null) {
            KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
            this.initFromKeyObject(keyObject);
        }
        if (this.isExportable.booleanValue()) {
            if (this.encoded == null) {
                this.encoded = SdkmsKeyService.getKeyValue(this.descriptor);
                if (this.encoded != null) {
                    try {
                        DerInputStream der = new DerInputStream(this.encoded);
                        DerValue[] data = der.getSequence(0);
                        int ver = data[0].getInteger();
                        if (ver != 0) {
                            LOGGER.error("Private key DER version is not 0");
                            return;
                        }
                        this.privateExponent = data[3].getBigInteger();
                        this.primeP = data[4].getBigInteger();
                        this.primeQ = data[5].getBigInteger();
                        this.primeExponentP = data[6].getBigInteger();
                        this.primeExponentQ = data[7].getBigInteger();
                        this.crtCoefficient = data[8].getBigInteger();
                    }
                    catch (IOException ex) {
                        LOGGER.error("Private key parsing failed", ex);
                    }
                }
            }
        } else {
            LOGGER.info("Trying to get key material of a non exportable key: " + ProviderUtil.toStringSobjectDescriptor(this.descriptor));
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public String getFormat() {
        return "raw";
    }

    @Override
    public byte[] getEncoded() {
        this.initPrivateKeyParamsIfExportable();
        return this.encoded;
    }

    @Override
    public Integer getKeySize() {
        return this.keySize;
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.initPrivateKeyParamsIfExportable();
        return this.privateExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        this.initPrivateKeyParamsIfExportable();
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        this.initPrivateKeyParamsIfExportable();
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        this.initPrivateKeyParamsIfExportable();
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        this.initPrivateKeyParamsIfExportable();
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        this.initPrivateKeyParamsIfExportable();
        return this.crtCoefficient;
    }
}

