/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.asym.rsa;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaOptions;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public class SdKmsRsa {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdKmsRsa.class));

    public static KeyObject generateKeyForRsaOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy encryptionPolicy, RsaSignaturePolicy signaturePolicy, String groupId, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, isTransientKey, "RSA");
            if (groupId != null) {
                sObjReq.setGroupId(groupId);
            }
            RsaOptions rsa = new RsaOptions();
            if (encryptionPolicy != null) {
                rsa.setEncryptionPolicy(Collections.singletonList(encryptionPolicy));
                sObjReq.setRsa(rsa);
            }
            if (signaturePolicy != null) {
                rsa.setSignaturePolicy(Collections.singletonList(signaturePolicy));
                sObjReq.setRsa(rsa);
            }
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "RSA");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during RSA Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForRsaOperation(List<KeyOperations> allowedKeyOperations, byte[] keyMaterial, RsaEncryptionPolicy encryptionPolicy, RsaSignaturePolicy signaturePolicy, String groupId, String alias) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(null, allowedKeyOperations, null, "RSA");
            if (alias != null && !alias.isEmpty()) {
                sObjReq.setName(alias);
            }
            if (groupId != null) {
                sObjReq.setGroupId(groupId);
            }
            if (keyMaterial != null) {
                sObjReq.setValue(keyMaterial);
            }
            RsaOptions rsa = new RsaOptions();
            if (encryptionPolicy != null) {
                rsa.setEncryptionPolicy(Arrays.asList(encryptionPolicy));
                sObjReq.setRsa(rsa);
            }
            if (signaturePolicy != null) {
                rsa.setSignaturePolicy(Arrays.asList(signaturePolicy));
                sObjReq.setRsa(rsa);
            }
            keyObject = SdkmsCommonService.importKeyForAlgorithm(sObjReq, "RSA");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during RSA Key import", apiException);
        }
        return keyObject;
    }
}

