/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.sym.aes;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class SdkmsAes {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsAes.class));

    public static KeyObject generateKeyForAesOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, isTransientKey, "AES");
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "AES");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Aes Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importAESKey(byte[] keyMaterial, Integer keySize, List<KeyOperations> allowedKeyOperations, String alias) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, null, "AES");
            if (keyMaterial != null) {
                sObjReq.setValue(keyMaterial);
            }
            if (alias != null && !alias.isEmpty()) {
                sObjReq.setName(alias);
            }
            keyObject = SdkmsCommonService.importKeyForAlgorithm(sObjReq, "AES");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Aes Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

