/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.sym.des;

import com.fortanix.sdkms.jce.provider.keys.sym.des.SdkmsDESKey;
import com.fortanix.sdkms.jce.provider.keys.sym.des.SdkmsDes;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.spec.SecurityObjectKeySpec;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;

public final class DESSecretKeyFactory
extends SecretKeyFactorySpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DESSecretKeyFactory.class));
    private List<KeyOperations> allowedKeyOperations;
    private String alias;

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        LOGGER.debug("DESSecretKeyFactory: import using keyspec");
        byte[] material = null;
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            this.alias = ((SecurityObjectKeySpec)keySpec).getAlias();
            keySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        if (keySpec instanceof DESKeySpec) {
            material = ((DESKeySpec)keySpec).getKey();
        }
        if (keySpec instanceof SecretKeySpec) {
            material = ((SecretKeySpec)keySpec).getEncoded();
        }
        if (material == null) {
            throw new InvalidKeySpecException("Key material not found. Cannot import DES key.");
        }
        KeyObject keyObject = SdkmsDes.importKeyForDesOperation(56, this.allowedKeyOperations, material, this.alias);
        return new SdkmsDESKey(keyObject);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        LOGGER.debug("DESSecretKeyFactory: get keyspec");
        try {
            if (DESKeySpec.class.isAssignableFrom(keySpec)) {
                return new DESKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        LOGGER.debug("DESSecretKeyFactory: translate key");
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof SdkmsDESKey) {
                    return key;
                }
                KeySpec keySpec = this.engineGetKeySpec(key, DESKeySpec.class);
                return this.engineGenerateSecret(keySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException("Failed to translate key", e);
            return null;
        }
    }
}

