/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.sym.des;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class SdkmsDes {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsDes.class));

    public static KeyObject generateKeyForDesOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, isTransientKey, "DES");
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "DES");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Des Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForDesOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, byte[] keyMaterial, String alias) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, null, "DES");
            if (keyMaterial != null) {
                sObjReq.setValue(keyMaterial);
            }
            if (alias != null && !alias.isEmpty()) {
                sObjReq.setName(alias);
            }
            keyObject = SdkmsCommonService.importKeyForAlgorithm(sObjReq, "DES");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during Des Key import keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

