/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.sym.desede;

import com.fortanix.sdkms.jce.provider.keys.sym.desede.SdkmsDESedeKey;
import com.fortanix.sdkms.jce.provider.keys.sym.desede.SdkmsDesede;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.spec.SecurityObjectKeySpec;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;

public final class DESedeSecretKeyFactory
extends SecretKeyFactorySpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DESedeSecretKeyFactory.class));
    private List<KeyOperations> allowedKeyOperations;

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        LOGGER.debug("DESede KeyFactory: import using keyspec");
        byte[] material = null;
        KeyObject keyObject = null;
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            keySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        if (keySpec instanceof DESedeKeySpec) {
            material = ((DESedeKeySpec)keySpec).getKey();
        }
        if (keySpec instanceof SecretKeySpec) {
            material = ((SecretKeySpec)keySpec).getEncoded();
        }
        if (material == null) {
            throw new InvalidKeySpecException("Key material not found. Cannot import DES3 key.");
        }
        keyObject = SdkmsDesede.importKeyForDesedeOperation(168, this.allowedKeyOperations, material);
        return new SdkmsDESedeKey(keyObject);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        LOGGER.debug("DESede KeyFactory: get keyspec");
        try {
            if (DESedeKeySpec.class.isAssignableFrom(keySpec)) {
                return new DESedeKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        LOGGER.debug("DESede KeyFactory: translate key");
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof SdkmsDESedeKey) {
                    return key;
                }
                KeySpec keySpec = this.engineGetKeySpec(key, DESedeKeySpec.class);
                return this.engineGenerateSecret(keySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            return null;
        }
    }
}

