/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.keys.sym.desede;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class SdkmsDesede {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsDesede.class));

    public static KeyObject generateKeyForDesedeOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, isTransientKey, "DESede");
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "DESede");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during TripleDES/DESede Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForDesedeOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, byte[] keyMaterial) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, null, "DESede");
            if (keyMaterial != null) {
                sObjReq.setValue(keyMaterial);
            }
            keyObject = SdkmsCommonService.importKeyForAlgorithm(sObjReq, "DESede");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during TripleDES/DESede Key Import keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

