/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.macs;

import com.fortanix.sdkms.jce.provider.macs.SdkmsHmacKey;
import com.fortanix.sdkms.jce.provider.macs.SdkmsMac;
import com.fortanix.sdkms.jce.provider.spec.SecurityObjectParameterSpec;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class KeyGeneratorCore {
    private static final Integer MIN_KEY_LENGTH = 32;
    private final String algorithm;
    private final int defaultKeySize;
    private int keySize;
    private List<KeyOperations> allowedKeyOperations;
    private boolean isTransientKey;

    KeyGeneratorCore(String name, int defaultKeySize) {
        this.algorithm = name;
        this.defaultKeySize = defaultKeySize;
        this.implInit();
    }

    public void implInit() {
        this.keySize = this.defaultKeySize;
    }

    public void implInit(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof SecurityObjectParameterSpec)) {
            throw new InvalidAlgorithmParameterException(this.algorithm + " key generation does not take any parameters");
        }
        this.allowedKeyOperations = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
        this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
    }

    public void implInit(int keysize, SecureRandom random) {
        if (keysize < MIN_KEY_LENGTH) {
            throw new InvalidParameterException("Key length must be at least " + MIN_KEY_LENGTH + " bits");
        }
        this.keySize = keysize;
    }

    public SecretKey implGenerateKey() {
        KeyObject keyObject = SdkmsMac.generateKeyForMacOperation(this.keySize, this.allowedKeyOperations, this.isTransientKey);
        return new SdkmsHmacKey(keyObject, this.algorithm);
    }

    public void implInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(this.algorithm + " key generation does not take any parameters");
    }

    static abstract class HmacSHA2KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core;

        protected HmacSHA2KG(String algoName, int len) {
            this.core = new KeyGeneratorCore(algoName, len);
        }

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit();
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params);
        }

        @Override
        protected void engineInit(int keysize, SecureRandom random) {
            this.core.implInit(keysize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }

        public static final class SHA512
        extends HmacSHA2KG {
            public SHA512() {
                super("HmacSHA512", 512);
            }
        }

        public static final class SHA384
        extends HmacSHA2KG {
            public SHA384() {
                super("HmacSHA384", 384);
            }
        }

        public static final class SHA256
        extends HmacSHA2KG {
            public SHA256() {
                super("HmacSHA256", 256);
            }
        }

        public static final class SHA160
        extends HmacSHA2KG {
            public SHA160() {
                super("HmacSHA1", 160);
            }
        }
    }
}

