/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.macs;

import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCommonService;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.DigestApi;
import com.fortanix.sdkms.v1.model.DigestAlgorithm;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.MacGenerateRequestEx;
import com.fortanix.sdkms.v1.model.MacGenerateResponse;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class SdkmsMac {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsMac.class));

    public static KeyObject generateKeyForMacOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            SobjectRequest sObjReq = SdkmsCommonService.getSObjectRequestForAlgorithm(keySize, allowedKeyOperations, isTransientKey, "HMAC");
            keyObject = SdkmsCommonService.generateKeyForAlgorithm(sObjReq, "HMAC");
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed in mac operation", apiException);
        }
        return keyObject;
    }

    public static byte[] computeMac(SobjectDescriptor sobjectDescriptor, DigestAlgorithm algorithm, byte[] data) {
        final MacGenerateRequestEx macRequest = new MacGenerateRequestEx();
        macRequest.setAlg(algorithm);
        macRequest.setData(data);
        macRequest.setKey(sobjectDescriptor);
        byte[] hmac = null;
        MacGenerateResponse digestResponse = null;
        try {
            digestResponse = (MacGenerateResponse)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

                @Override
                public Object execute() throws ApiException {
                    return new DigestApi(ApiClientSetup.getInstance().getApiClient()).computeMacEx(macRequest);
                }

                @Override
                public String getDescription() {
                    return "MacGeneration";
                }
            });
            hmac = digestResponse.getDigest();
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Failed in compute mac", apiException);
        }
        return hmac;
    }
}

