/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.config.Configuration;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.AuthenticationApi;
import com.fortanix.sdkms.v1.auth.ApiKeyAuth;
import com.fortanix.sdkms.v1.model.AuthResponse;
import com.fortanix.sdkms.v1.model.VersionResponse;
import java.util.Arrays;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ApiClientSetup {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger((String)"SDKMS-API"));
    private static final List<Integer> invalidSessionCodes = Arrays.asList(401, 403);
    private static final List<String> invalidSessionMessages = Arrays.asList("Session does not exist", "Session has expired");
    private static ApiClientSetup instance;
    private ApiClient apiClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApiClientSetup initialize() {
        if (instance != null) return instance;
        Class<ApiClientSetup> clazz = ApiClientSetup.class;
        synchronized (ApiClientSetup.class) {
            if (instance != null) return instance;
            instance = new ApiClientSetup();
            LOGGER.debug("Created instance of ApiClientSetup");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ApiClientSetup getInstance() {
        if (instance == null) {
            return ApiClientSetup.initialize();
        }
        return instance;
    }

    public Object ensureValidSession(ISdkmsCommand command) throws ApiException {
        Object response = null;
        try {
            response = command.execute();
        }
        catch (ApiException apiException) {
            if (this.isSessionValid(apiException)) {
                throw apiException;
            }
            LOGGER.info("Session is expired. Trying re-login");
            this.makeLoginRequest();
            response = command.execute();
        }
        return response;
    }

    private ApiClientSetup() {
        Configuration configuration = Configuration.getInstance();
        this.apiClient = new ApiClient();
        this.apiClient.setBasicAuthString(configuration.getSdkmsApiKey());
        this.apiClient.setBasePath(configuration.getSdkmsServerUrl());
        this.apiClient.setMaxConnections(configuration.getMaxConn());
        this.apiClient.setKeepAliveDuration(configuration.getKeepAliveDuration());
    }

    public boolean isSessionValid(ApiException apiException) {
        if (invalidSessionCodes.contains(apiException.getCode())) {
            return false;
        }
        return !invalidSessionMessages.stream().anyMatch(a -> apiException.getMessage().contains((CharSequence)a));
    }

    public void makeLoginRequest() {
        try {
            AuthResponse authResponse = new AuthenticationApi(this.apiClient).authorize();
            String bearerToken = authResponse.getAccessToken();
            ApiKeyAuth bearerAuth = (ApiKeyAuth)this.apiClient.getAuthentication("bearerToken");
            bearerAuth.setApiKey(bearerToken);
            bearerAuth.setApiKeyPrefix("Bearer");
        }
        catch (ApiException e) {
            LOGGER.logAndRaiseProviderException("SDKMS authentication Failed", e);
        }
    }

    public String getServerVersion() {
        try {
            VersionResponse versionResponse = new AuthenticationApi(this.apiClient).getServerVersion();
            return versionResponse.getVersion();
        }
        catch (ApiException e) {
            LOGGER.logAndRaiseProviderException("SDKMS version fetch failed", e);
            return null;
        }
    }

    public void logout() {
        try {
            LOGGER.info("Session Termination");
            new AuthenticationApi(this.apiClient).terminate();
        }
        catch (ApiException apiException) {
            // empty catch block
        }
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }
}

